/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.gomu;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.MathHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.GomuHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoBazookaProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoGrizzlyMagnumProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoJetBazookaProjectile;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gomu.GomuGomuNoLeoBazookaProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class GomuGomuNoBazookaAbility
extends ChargeableAbility {
    public static final GomuGomuNoBazookaAbility INSTANCE = new GomuGomuNoBazookaAbility();

    public GomuGomuNoBazookaAbility() {
        super("Gomu Gomu no Bazooka", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Hits the enemy with both hands to launch them away");
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(2.0);
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        AbilityProjectileEntity projectile = null;
        float speed = 2.0f;
        if (GomuHelper.hasGearFourthActive(props)) {
            projectile = new GomuGomuNoLeoBazookaProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            this.setMaxCooldown(12.0);
            this.setDisplayName("Gomu Gomu no Leo Bazooka");
            speed = 3.0f;
        } else if (GomuHelper.hasGearThirdActive(props)) {
            projectile = new GomuGomuNoGrizzlyMagnumProjectile(player.field_70170_p, (LivingEntity)player);
            projectile.setCollisionSize(2.5);
            this.setMaxCooldown(15.0);
            this.setDisplayName("Gomu Gomu no Grizzly Magnum");
            speed = 1.8f;
        } else if (GomuHelper.hasGearSecondActive(props)) {
            projectile = new GomuGomuNoJetBazookaProjectile(player.field_70170_p, (LivingEntity)player);
            this.setMaxCooldown(7.0);
            this.setDisplayName("Gomu Gomu no Jet Bazooka");
            speed = 3.0f;
        } else {
            projectile = new GomuGomuNoBazookaProjectile(player.field_70170_p, (LivingEntity)player);
            this.setDisplayName("Gomu Gomu no Bazooka");
            this.setMaxCooldown(10.0);
        }
        player.field_70170_p.func_217376_c((Entity)projectile);
        projectile.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, speed, 0.0f);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.GOMU_SFX, SoundCategory.PLAYERS, 0.8f, (float)MathHelper.func_151237_a((double)(player.func_70681_au().nextDouble() * 2.0), (double)1.0, (double)1.3f));
        return true;
    }
}

