/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.goro.LightningEntity;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.goro.ElThorParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class ElThorAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new ElThorAbility();
    private static final ElThorParticleEffect PARTICLES = new ElThorParticleEffect();
    private LightningEntity bolt = null;
    boolean playedSound = false;
    private List<Vec3d> positions = new ArrayList<Vec3d>();
    private static final float COOLDOWN = 10.0f;
    float multi = 1.0f;

    public ElThorAbility() {
        super("El Thor", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Focuses a large cluster of electricity above the target, then sends a powerful lightning bolt crashing down from the sky");
        this.setMaxCooldown(10.0);
        this.setMaxChargeTime(3.0);
        this.setCancelable();
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
        this.duringCooldownEvent = this::duringCooldownEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        this.positions.clear();
        this.bolt = null;
        this.playedSound = false;
        ElThorAbility.PARTICLES.aiming = true;
        ElThorAbility.PARTICLES.ownerID = player.func_145782_y();
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        if (chargeTimer % 2 == 0) {
            PARTICLES.spawn(player.field_70170_p, i, j, k, 0.0, 0.0, 0.0);
        }
        AbilityHelper.slowEntityFall((LivingEntity)player);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.getChargeTime() > this.getMaxChargeTime() - 20) {
            return false;
        }
        ElThorAbility.PARTICLES.aiming = false;
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player);
        boolean hasTomoeDrums = ((ItemStack)player.field_71071_by.field_70460_b.get(2)).func_77973_b() == ModArmors.TOMOE_DRUMS;
        float time = (float)this.getChargeTime() / (float)this.getMaxChargeTime();
        this.multi = (0.3f + (1.0f - time) * 0.7f) * (hasTomoeDrums ? 1.5f : 1.0f);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b;
        double k = mop.func_216347_e().field_72449_c;
        int f = 0;
        int max = 1;
        if (hasTomoeDrums && player.func_225608_bj_()) {
            this.setDisplayName("Mamaragan");
            max += 40;
            this.multi /= 2.0f;
        } else {
            this.setDisplayName("El Thor");
        }
        double x = 0.0;
        double z = 0.0;
        while (f < max) {
            if (f > 0) {
                x = WyHelper.randomWithRange(-40, 40);
                z = WyHelper.randomWithRange(-40, 40);
            }
            PARTICLES.spawn(player.field_70170_p, i + x, j, k + z, 0.0, 0.0, 0.0);
            this.positions.add(new Vec3d(i + x, j, k + z));
            ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
            LightningEntity bolt = new LightningEntity((Entity)player, i + x, j + 72.0, k + z, 0.0f, 90.0f, 72.0f + 16.0f * this.multi, 24.0f);
            this.setBoltPropieties(bolt, 1.4f, 0.0f, 110, 50, false, Color.WHITE);
            player.field_70170_p.func_217376_c((Entity)bolt);
            long seed = bolt.seed;
            this.bolt = new LightningEntity((Entity)player, i + x, j + 72.0, k + z, 0.0f, 90.0f, 72.0f + 16.0f * this.multi, 24.0f);
            this.bolt.seed = seed;
            this.setBoltPropieties(this.bolt, 1.45f, 50.0f, 120, 50, true, null);
            player.field_70170_p.func_217376_c((Entity)this.bolt);
            ++f;
        }
        this.setMaxCooldown(Math.min(10.0f * Math.min(this.multi, 1.0f) * (float)Math.max(max / 4, 1), 30.0f));
        return true;
    }

    public void setBoltPropieties(LightningEntity bolt, float size, float damage, int timeAlive, int resetTime, boolean explodes, @Nullable Color color) {
        bolt.setAngle(160);
        bolt.setBranches(1);
        bolt.setSegments(1);
        bolt.setSize(size * this.multi);
        bolt.setBoxSizeDivision(0.225f);
        bolt.disableLightningMovement();
        bolt.setExplosion(explodes ? (int)(9.0f * this.multi) : 0, true, 0.0f);
        if (color != null) {
            bolt.setColor(color);
        }
        bolt.setAliveTicks(timeAlive);
        bolt.setDamage(damage * this.multi);
        bolt.setTargetTimeToReset(resetTime);
    }

    private void duringCooldownEvent(PlayerEntity player, int i) {
        if (this.bolt != null && this.bolt.func_70089_S() && this.bolt.firstContactBlocks.size() > 0 && !this.playedSound) {
            this.playedSound = true;
            player.field_70170_p.func_184133_a(null, this.bolt.func_180425_c().func_177979_c(72), ModSounds.EL_THOR_SFX, SoundCategory.PLAYERS, 3.0f, 3.0f);
        }
        if (this.bolt != null && this.bolt.func_70089_S() || i % 2 == 0) {
            this.positions.forEach(vec -> PARTICLES.spawn(player.field_70170_p, vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, 0.0, 0.0, 0.0));
        }
    }
}

