/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.goro;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import xyz.pixelatedw.mineminenomi.api.abilities.IExtraUpdateData;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;

public class ShinzoMassageAbility
extends PassiveAbility
implements IExtraUpdateData {
    public static final ShinzoMassageAbility INSTANCE = new ShinzoMassageAbility();
    private double strain = 0.0;
    private int healTicks = 0;
    private int outTicks = 0;

    public ShinzoMassageAbility() {
        super("Shinzo Massage", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(60.0);
        this.setDescription("The user restarts their own heart after dying using lightning powers");
        this.hideInGUI(false);
    }

    @Override
    public void tick(PlayerEntity user) {
        if (user.field_70170_p.field_72995_K) {
            return;
        }
        if (this.strain > 0.0) {
            ++this.healTicks;
            if ((double)this.healTicks % (4800.0 + 2400.0 * this.strain) == 0.0) {
                this.resetReviveTime(user, true);
            }
        }
        EffectInstance effect = user.func_70660_b(ModEffects.UNCONSCIOUS);
        if (!AbilityHelper.isAffectedByWater((LivingEntity)user) && !DevilFruitHelper.kairosekiChecks((LivingEntity)user) && effect != null && this.strain < 4.0) {
            int time = (int)(60.0 + 180.0 * this.strain / 4.0);
            if (this.outTicks >= time) {
                user.func_195063_d(effect.func_188419_a());
                this.strain = Math.min(this.strain + (double)Math.min((float)effect.func_76459_b() / 1200.0f, 1.0f), 4.0);
                user.func_195064_c(new EffectInstance(ModEffects.SHINZO_MASSAGE, 40, 5, false, false));
                this.outTicks = 0;
                return;
            }
            ++this.outTicks;
        }
    }

    public void increaseReviveTime() {
        this.strain = Math.min(this.strain + Math.max(WyHelper.randomDouble(), 0.25), 4.0);
        this.healTicks = 0;
    }

    public void resetReviveTime(PlayerEntity user, boolean resetStrain) {
        if (resetStrain) {
            this.strain = 0.0;
        }
        this.healTicks = 0;
        this.stopCooldown(user);
    }

    public double getStrain() {
        return this.strain;
    }

    @Override
    public CompoundNBT getExtraData() {
        CompoundNBT nbt = new CompoundNBT();
        nbt.func_74780_a("strain", this.strain);
        nbt.func_74768_a("healTicks", this.healTicks);
        return nbt;
    }

    @Override
    public void setExtraData(CompoundNBT nbt) {
        this.strain = nbt.func_74769_h("strain");
        this.healTicks = nbt.func_74762_e("healTicks");
    }
}

