/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class KenbunshokuHakiAuraAbility
extends ContinuousAbility
implements IHakiAbility,
IParallelContinuousAbility {
    public static final KenbunshokuHakiAuraAbility INSTANCE = new KenbunshokuHakiAuraAbility();
    private boolean hasGoro = false;

    public KenbunshokuHakiAuraAbility() {
        super("Kenbunshoku Haki: Aura", AbilityHelper.getHakiCategory());
        this.setDescription("Uses Observation Haki to see the auras of all nearby creatures, differentiated by colors");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuity;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        this.hasGoro = DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GORO_GORO_NO_MI);
        WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), HakiDataCapability.get((LivingEntity)player)), player);
        WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), EntityStatsCapability.get((LivingEntity)player)), player);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.KENBUNSHOKU_HAKI_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void duringContinuity(PlayerEntity player, int passiveTimer) {
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, this.hasGoro ? -1 : -1 + passiveTimer / 5900);
        if (isOnMaxOveruse) {
            this.stopContinuity(player);
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        int cooldown = (int)WyHelper.clamp(Math.round((double)this.continueTime / 30.0), 3L, 30L) / (this.hasGoro ? 2 : 1);
        if (!this.hasGoro && this.continueTime / 20 > 5) {
            HakiHelper.checkForHakiOveruse(player, 100);
        }
        this.setMaxCooldown(cooldown);
        return true;
    }

    @Override
    public HakiType getType() {
        return HakiType.KENBUNSHOKU;
    }
}

