/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.haki;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.abilities.IHakiAbility;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.IParallelContinuousAbility;

public class KenbunshokuHakiFutureSightAbility
extends ContinuousAbility
implements IHakiAbility,
IParallelContinuousAbility {
    public static final KenbunshokuHakiFutureSightAbility INSTANCE = new KenbunshokuHakiFutureSightAbility();
    public float maxProtection = 0.0f;
    protected float protection = 0.0f;
    protected boolean havesGoro = false;

    public KenbunshokuHakiFutureSightAbility() {
        super("Kenbunshoku Haki: Future Sight", AbilityHelper.getHakiCategory());
        this.setDescription("Using Observation Haki allows the user to see a short period into the future to avoid attacks");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (!HakiHelper.canEnableHaki(player)) {
            return false;
        }
        this.havesGoro = DevilFruitCapability.get((LivingEntity)player).hasDevilFruit(ModAbilities.GORO_GORO_NO_MI);
        this.protection = this.maxProtection = this.calculateMaxProtection(player);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.KENBUNSHOKU_HAKI_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int i) {
        IHakiData hakiProps;
        boolean isOnMaxOveruse = HakiHelper.checkForHakiOveruse(player, -1);
        if (isOnMaxOveruse || 0.0f > this.protection) {
            int time = Math.round(40.0f + 60.0f * (1.0f - this.maxProtection / 200.0f));
            this.setMaxCooldown(time);
            this.stopContinuity(player);
        }
        if ((hakiProps = HakiDataCapability.get((LivingEntity)player)).getHakiOveruse() == 0 && this.maxProtection > this.protection) {
            this.protection = Math.min(this.protection + 5.0f, this.maxProtection);
        }
    }

    private float calculateMaxProtection(PlayerEntity player) {
        IEntityStats sprops = EntityStatsCapability.get((LivingEntity)player);
        IHakiData hakiProps = HakiDataCapability.get((LivingEntity)player);
        float dorikiPower = (float)sprops.getDoriki() / 1000.0f;
        float hakiPower = hakiProps.getKenbunshokuHakiExp() * 0.75f;
        float percentageOveruse = 1.0f - (float)hakiProps.getHakiOveruse() / HakiHelper.getMaxOveruse(player) / 2.0f;
        return (15.0f + dorikiPower + hakiPower) * (float)(this.havesGoro ? 2 : 1) * percentageOveruse;
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        if (this.protection > 0.0f) {
            this.setMaxCooldown(5.0f + 30.0f * (1.0f - this.protection / 200.0f));
        }
        return true;
    }

    public void reduceProtection(float amount) {
        this.protection -= amount;
    }

    @Override
    public HakiType getType() {
        return HakiType.KENBUNSHOKU;
    }
}

