/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.horo;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.abilities.DamagedContinuousAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.PhysicalBodyEntity;
import xyz.pixelatedw.mineminenomi.init.ModI18n;

public class YutaiRidatsuAbility
extends DamagedContinuousAbility {
    public static final YutaiRidatsuAbility INSTANCE = new YutaiRidatsuAbility();
    private double posX;
    private double posY;
    private double posZ;
    private PhysicalBodyEntity body;

    public YutaiRidatsuAbility() {
        super("Yutai Ridatsu", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user's spirit leaves their body, allowing them to freely explore the nearby areas");
        this.setThreshold(60.0);
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
        this.onDamagedEvent = this::onDamagedEvent;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_SUVIVAL_ONLY, new Object[0]));
            return false;
        }
        player.func_213293_j(0.0, 5.0, 0.0);
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
        player.field_70133_I = true;
        this.posX = player.func_213303_ch().func_82615_a();
        this.posY = player.func_213303_ch().func_82617_b();
        this.posZ = player.func_213303_ch().func_82616_c();
        this.body = new PhysicalBodyEntity(player.field_70170_p);
        this.body.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), player.field_70177_z, player.field_70125_A);
        this.body.setOwner(player.func_110124_au());
        player.field_70170_p.func_217376_c((Entity)this.body);
        this.body.func_70606_j(player.func_110143_aJ());
        this.body.setParentAbility(this);
        return true;
    }

    private void duringContinuityEvent(PlayerEntity player, int continueTime) {
        if (Math.sqrt(player.func_70092_e(this.posX, this.posY, this.posZ)) > 40.0) {
            this.stopContinuity(player);
        }
        if (this.body == null) {
            this.stopContinuity(player);
            return;
        }
        if (!this.body.func_70089_S()) {
            player.func_70097_a(DamageSource.field_76376_m, player.func_110138_aP());
        }
    }

    private boolean onEndContinuityEvent(PlayerEntity player) {
        double cooldown = (float)this.continueTime / 20.0f;
        this.setMaxCooldown(cooldown);
        if (this.body != null) {
            this.body.func_70106_y();
            this.body = null;
            player.func_70634_a(this.posX, this.posY, this.posZ);
        }
        return true;
    }

    private boolean onDamagedEvent(LivingEntity entity, DamageSource damageSource, double v) {
        if (entity instanceof PlayerEntity) {
            if (((PlayerEntity)entity).func_184812_l_() || entity.func_175149_v()) {
                return false;
            }
            return damageSource == DamageSource.field_76376_m || damageSource.func_151517_h();
        }
        return false;
    }
}

