/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.kage;

import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModItems;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.kage.ChargeableKageParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class KageKakumeiAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new KageKakumeiAbility();
    private static final ParticleEffect CHARGE_PARTICLE = new ChargeableKageParticleEffect();

    public KageKakumeiAbility() {
        super("Kage Kakumei", AbilityHelper.getDevilFruitCategory());
        this.setDescription("The user absorbs 10 shadows at once to boost their physical abilities");
        this.setMaxCooldown(50.0);
        this.setMaxChargeTime(5.0);
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::endChargeEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        int shadowSlot = this.getShadowSlot(player);
        if (shadowSlot == -1) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_SHADOWS, new Object[0]));
            return false;
        }
        ItemStack stack = player.field_71071_by.func_70301_a(shadowSlot);
        if (stack.func_190916_E() < 10) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ENOUGH_SHADOWS, new Object[0]));
            return false;
        }
        player.field_71071_by.func_70298_a(shadowSlot, 10);
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int i) {
        CHARGE_PARTICLE.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean endChargeEvent(PlayerEntity player) {
        player.func_195064_c(new EffectInstance(Effects.field_76424_c, 400, 2));
        player.func_195064_c(new EffectInstance(Effects.field_76429_m, 400, 1));
        player.func_195064_c(new EffectInstance(Effects.field_76420_g, 400, 4));
        player.func_195064_c(new EffectInstance(Effects.field_180152_w, 400, 3));
        player.func_70691_i(20.0f + player.func_110138_aP() / 10.0f);
        return true;
    }

    public int getShadowSlot(PlayerEntity player) {
        if (!player.field_71071_by.func_70431_c(new ItemStack((IItemProvider)ModItems.SHADOW))) {
            return -1;
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stack = player.field_71071_by.func_70301_a(i);
            if (stack.func_190926_b() || stack.func_77973_b() != ModItems.SHADOW) continue;
            return i;
        }
        return -1;
    }
}

