/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.ope;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.ope.RoomAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.ope.CounterShockParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PunchAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;

public class CounterShockAbility
extends PunchAbility {
    public static final Ability INSTANCE = new CounterShockAbility();
    private static final ParticleEffect PARTICLES = new CounterShockParticleEffect();

    public CounterShockAbility() {
        super("Counter Shock", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(20.0);
        this.setDescription("Releases releases a electrical surge like a defibrillator from the users fist which shocks the opponent");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.onHitEntityEvent = this::onHitEntity;
    }

    private boolean onStartContinuityEvent(PlayerEntity player) {
        RoomAbility ability = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(RoomAbility.INSTANCE);
        if (ability == null || !ability.isEntityInThisRoom((Entity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_ROOM, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private float onHitEntity(PlayerEntity player, LivingEntity target) {
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)player, player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 2.0f);
        explosion.setStaticDamage(3.0f);
        explosion.setExplosionSound(true);
        explosion.setDamageOwner(false);
        explosion.setDestroyBlocks(false);
        explosion.setFireAfterExplosion(false);
        explosion.func_199592_a(ModDamageSource.LIGHTNING_BOLT.causeEntityDamageFromSource((Entity)player));
        explosion.setSmokeParticles(new CommonExplosionParticleEffect(1));
        explosion.setDamageEntities(true);
        explosion.doExplosion();
        PARTICLES.spawn(target.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 0.0, 0.0, 0.0);
        return 17.0f;
    }
}

