/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.pika;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.SoundCategory;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.pika.AmaterasuProjectile;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.pika.ChargingPikaParticleEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class AmaterasuAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new AmaterasuAbility();
    private static final ParticleEffect PARTICLES = new ChargingPikaParticleEvent();

    public AmaterasuAbility() {
        super("Amaterasu", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(14.0);
        this.setMaxChargeTime(2.0);
        this.setDescription("Creates an immense beam of light, which causes massive damage");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.PIKA_CHARGE_SFX, SoundCategory.PLAYERS, 0.25f, 0.85f);
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int timer) {
        AbilityHelper.slowEntityFall((LivingEntity)player);
        PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        AmaterasuProjectile proj = new AmaterasuProjectile(player.field_70170_p, (LivingEntity)player);
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 5.0f, 1.0f);
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.PIKA_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }
}

