/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.suna;

import java.util.ArrayList;
import java.util.Arrays;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.BucketItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.api.SpecialEffect;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.suna.DesertEncierroParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class DesertEncierroAbility
extends ChargeableAbility {
    public static final Ability INSTANCE = new DesertEncierroAbility();
    private static final ParticleEffect PARTICLES = new DesertEncierroParticleEffect();
    private LivingEntity grabbedEntity = null;

    public DesertEncierroAbility() {
        super("Desert Encierro", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Quickly drains the enemy in front of the user of their moisture, leaving them weak for a few seconds");
        this.setMaxCooldown(15.0);
        this.setMaxChargeTime(5.0);
        this.onStartChargingEvent = this::onUseEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onUseEvent(PlayerEntity player) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 3.0);
        if (mop instanceof EntityRayTraceResult) {
            EntityRayTraceResult entityRayTraceResult = (EntityRayTraceResult)mop;
            if (entityRayTraceResult.func_216348_a() instanceof LivingEntity) {
                LivingEntity e = (LivingEntity)entityRayTraceResult.func_216348_a();
                if (!e.func_70089_S() || DevilFruitCapability.get(e).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, e)) {
                    return false;
                }
                this.grabbedEntity = e;
                DesertEncierroAbility.drainLiquids(this.grabbedEntity, (int)WyHelper.randomWithRange(0, 1), (int)WyHelper.randomWithRange(1, 3), (int)WyHelper.randomWithRange(0, 1));
            }
        } else {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NO_TARGET, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        if (!this.grabbedEntity.func_70089_S() || !AbilityHelper.canUseMomentumAbility(player) || DevilFruitCapability.get(this.grabbedEntity).isLogia() && !HakiHelper.hasHardeningActive((LivingEntity)player) || AbilityHelper.isTargetBlockingAbility(player, this.grabbedEntity)) {
            this.stopCharging(player);
        }
        PARTICLES.spawn(this.grabbedEntity.field_70170_p, this.grabbedEntity.func_226277_ct_(), this.grabbedEntity.func_226278_cu_(), this.grabbedEntity.func_226281_cx_(), 0.0, 0.0, 0.0);
        this.grabbedEntity.field_70125_A = this.grabbedEntity.field_70127_C;
        this.grabbedEntity.field_70177_z = this.grabbedEntity.field_70126_B;
        this.grabbedEntity.func_195064_c(new EffectInstance(ModEffects.MOVEMENT_BLOCKED, 5, 1));
        this.grabbedEntity.func_70097_a(ModDamageSource.causeAbilityDamage(player, this).func_76348_h().func_151518_m(), 2.0f);
        float distance = 2.0f;
        Vec3d lookVec = player.func_70040_Z();
        Vec3d pos = new Vec3d(player.func_226277_ct_() + lookVec.field_72450_a * (double)distance, player.func_226278_cu_() + (double)(player.func_70047_e() / 2.0f) + lookVec.field_72448_b * (double)distance, player.func_226281_cx_() + lookVec.field_72449_c * (double)distance);
        this.grabbedEntity.func_70634_a(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        if (this.grabbedEntity == null) {
            return false;
        }
        this.grabbedEntity.func_70097_a(ModDamageSource.causeAbilityDamage(player, this).func_76348_h().func_151518_m(), 20.0f);
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_82731_v, 200, 4, false, false));
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_76438_s, 300, 5, false, false));
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_76437_t, 300, 1, false, false));
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_76421_d, 300, 1, false, false));
        this.grabbedEntity.func_195064_c(new EffectInstance(Effects.field_76419_f, 300, 1, false, false));
        return true;
    }

    public static void drainLiquids(LivingEntity entity, int effects, int potions, int buckets) {
        if (entity == null || !entity.func_70089_S()) {
            return;
        }
        int cleanBottles = 0;
        int cleanBuckets = 0;
        int cleanEffects = 0;
        for (EffectInstance eff : entity.func_70651_bq()) {
            if (eff == null || effects <= cleanEffects || !eff.func_188419_a().func_188408_i() || 1 < eff.func_76458_c() || eff.func_188419_a() instanceof SpecialEffect) continue;
            ++cleanEffects;
            Effect potion = eff.func_188419_a();
            entity.func_184596_c(potion);
            if (!(entity instanceof ServerPlayerEntity)) continue;
            ((ServerPlayerEntity)entity).field_71135_a.func_147359_a((IPacket)new SRemoveEntityEffectPacket(entity.func_145782_y(), potion));
        }
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            ArrayList<Item> items = new ArrayList<Item>(Arrays.asList(Items.field_151068_bn, Items.field_185156_bI, Items.field_185155_bH));
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                BucketItem item;
                if (items.contains(player.field_71071_by.func_70301_a(i).func_77973_b()) && potions > cleanBottles) {
                    player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)Items.field_190931_a));
                    ++cleanBottles;
                    continue;
                }
                if (!(player.field_71071_by.func_70301_a(i).func_77973_b() instanceof BucketItem) || buckets <= cleanBuckets || (item = (BucketItem)player.field_71071_by.func_70301_a(i).func_77973_b()).getFluid() == Fluids.field_204541_a || item.getFluid() == Fluids.field_204547_b) continue;
                player.field_71071_by.func_70299_a(i, new ItemStack((IItemProvider)Items.field_190931_a));
                ++cleanBuckets;
            }
            if (cleanBottles > 0) {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151069_bo, cleanBottles));
            }
            if (cleanBuckets > 0) {
                player.func_191521_c(new ItemStack((IItemProvider)Items.field_151133_ar, cleanBuckets));
            }
        }
    }
}

