/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.swordsman;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SAnimateHandPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IMultiTargetAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModSounds;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class ShiShishiSonsonAbility
extends Ability
implements IMultiTargetAbility {
    public static final ShiShishiSonsonAbility INSTANCE = new ShiShishiSonsonAbility();

    public ShiShishiSonsonAbility() {
        super("Shi Shishi Sonson", AbilityHelper.getStyleCategory());
        this.setMaxCooldown(9.0);
        this.setDescription("The user dashes forward and rapidly slashes the opponent");
        this.onUseEvent = this::onUseEvent;
        this.duringCooldownEvent = this::duringCooldown;
    }

    private boolean onUseEvent(PlayerEntity player) {
        boolean hakiActiveFlag;
        if (!AbilityHelper.canUseMomentumAbility(player)) {
            return false;
        }
        if (!AbilityHelper.canUseSwordsmanAbilities((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NEED_SWORD, new Object[0]));
            return false;
        }
        this.clearTargets();
        ItemStack stack = player.func_184614_ca();
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        BusoshokuHakiImbuingAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        boolean bl = hakiActiveFlag = ability != null && ability.isContinuous();
        if (!hakiActiveFlag) {
            stack.func_222118_a(1, (LivingEntity)player, user -> user.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        Vec3d speed = WyHelper.propulsion((LivingEntity)player, 3.0, 3.0);
        player.func_213293_j(speed.field_72450_a, 0.2, speed.field_72449_c);
        player.field_70133_I = true;
        ((ServerWorld)player.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SAnimateHandPacket((Entity)player, 0));
        player.field_70170_p.func_184133_a(null, player.func_180425_c(), ModSounds.DASH_ABILITY_SWOOSH_SFX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        return true;
    }

    private void duringCooldown(PlayerEntity player, int cooldownTimer) {
        if (this.canDealDamage()) {
            List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 1.6, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
            list.remove(player);
            list.forEach(entity -> {
                if (this.isTarget((LivingEntity)entity) && player.func_70685_l((Entity)entity)) {
                    entity.func_70097_a(DamageSource.func_76365_a((PlayerEntity)player), 15.0f);
                }
            });
        }
    }

    public boolean canDealDamage() {
        return this.cooldown > this.getMaxCooldown() * 0.9;
    }
}

