/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.UUID;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import xyz.pixelatedw.mineminenomi.api.abilities.ZoanAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.PhoenixAssaultZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.effects.common.LogiaParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class PhoenixAssaultPointAbility
extends ZoanAbility {
    public static final PhoenixAssaultPointAbility INSTANCE = new PhoenixAssaultPointAbility();
    private static final AttributeModifier REGEN_RATE_MODIFIER = new AttributeModifier(UUID.fromString("eb43ce22-3c5a-45a0-810c-03c0f552efe7"), "Health Regeneration Speed Multiplier", (double)0.8f, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final AttributeModifier STRENGTH_MODIFIER = new AttributeModifier(UUID.fromString("eb43ce22-3c5a-45a0-810c-03c0f552efe7"), "Strength Modifier", 2.0, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    private static final LogiaParticleEffect PARTICLES = new LogiaParticleEffect(ModParticleTypes.BLUE_FLAME);

    public PhoenixAssaultPointAbility() {
        super("Phoenix Assault Point", AbilityHelper.getDevilFruitCategory(), PhoenixAssaultZoanInfo.INSTANCE);
        this.setDescription("Transforms the user into a half-phoenix hybrid, which focuses on speed and healing, Allows the user to use 'Hoo In', 'Blue Bird' and 'Flame of Restoration'");
        this.onStartContinuityEvent = this::onStartContinuityEvent;
        this.duringContinuityEvent = this::duringContinuityEvent;
        this.onEndContinuityEvent = this::onEndContinuityEvent;
        this.addZoanModifier(ModAttributes.REGEN_RATE, REGEN_RATE_MODIFIER);
        this.addEmptyHandZoanModifier(SharedMonsterAttributes.field_111264_e, STRENGTH_MODIFIER);
    }

    @Override
    protected boolean onStartContinuityEvent(PlayerEntity player) {
        if (!super.onStartContinuityEvent(player)) {
            return false;
        }
        if (player.func_184812_l_() || player.func_175149_v()) {
            return super.onStartContinuityEvent(player);
        }
        player.field_71075_bZ.field_75101_c = true;
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        return true;
    }

    @Override
    public void duringContinuityEvent(PlayerEntity player, int activeTime) {
        super.duringContinuityEvent(player, activeTime);
        if (player.func_110138_aP() > player.func_110143_aJ() && !AbilityHelper.isNearbyKairoseki(player) && player.func_71024_bL().func_75116_a() > 0) {
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() - Math.random(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            PARTICLES.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_() + Math.random(), player.func_226281_cx_(), Math.random(), 0.0, Math.random());
            int exhaustion = (int)(5.0 * Math.floor(Math.abs(player.func_71024_bL().func_75116_a() / 5)));
            if (activeTime % (20 + (20 - exhaustion / 2)) == 0 && player.field_70172_ad == 0) {
                player.func_70691_i((float)(WyHelper.randomDouble() + (double)((float)exhaustion / 20.0f)));
                player.func_71020_j(0.25f + (float)exhaustion / 60.0f);
            }
        }
        if (player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111126_e() < 0.0 || AbilityHelper.isNearbyKairoseki(player) || 6 > player.func_71024_bL().func_75116_a()) {
            player.field_71075_bZ.field_75101_c = false;
            player.field_71075_bZ.field_75100_b = false;
        } else {
            player.field_71075_bZ.field_75101_c = true;
            boolean canFly = DevilFruitHelper.isFlyingAtMaxHeight(player, 128.0);
            if (player.field_71075_bZ.field_75100_b) {
                if (player.field_70173_aa % 20 == 0) {
                    player.func_71020_j(0.2f);
                }
                DevilFruitHelper.vanillaFlightThreshold((LivingEntity)player, canFly ? 256 : (int)player.func_226278_cu_() - 1);
                player.field_70143_R = 0.0f;
            }
        }
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
    }

    @Override
    protected boolean onEndContinuityEvent(PlayerEntity player) {
        if (player.func_184812_l_() || player.func_175149_v()) {
            return super.onEndContinuityEvent(player);
        }
        player.field_71075_bZ.field_75101_c = false;
        player.field_71075_bZ.field_75100_b = false;
        ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
        return super.onEndContinuityEvent(player);
    }
}

