/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixAssaultPointAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.toriphoenix.PhoenixGoenProjectile;
import xyz.pixelatedw.mineminenomi.entities.zoan.PhoenixAssaultZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;

public class PhoenixGoenAbility
extends RepeaterAbility {
    public static final PhoenixGoenAbility INSTANCE = new PhoenixGoenAbility();

    public PhoenixGoenAbility() {
        super("Phoenix Goen", AbilityHelper.getDevilFruitCategory());
        this.setMaxCooldown(14.0);
        this.setMaxRepeaterCount(6, 5);
        this.setDescription("Launches high speed blue flames while midair.");
        this.onStartContinuityEvent = this::onStartContinuity;
        this.onUseEvent = this::onUseEvent;
    }

    private boolean onStartContinuity(PlayerEntity player) {
        if (!PhoenixAssaultZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), PhoenixAssaultPointAbility.INSTANCE.getName()}));
            return false;
        }
        if (player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_AIR, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private boolean onUseEvent(PlayerEntity player) {
        PhoenixGoenProjectile proj = new PhoenixGoenProjectile(player.field_70170_p, (LivingEntity)player, player.func_70040_Z());
        player.field_70170_p.func_217376_c((Entity)proj);
        proj.func_184538_a((Entity)player, player.field_70125_A, player.field_70177_z, 0.0f, 2.5f, 5.0f);
        return true;
    }
}

