/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.toriphoenix;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.network.play.server.SPlayerAbilitiesPacket;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xyz.pixelatedw.mineminenomi.abilities.toriphoenix.PhoenixFlyPointAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.entities.zoan.PhoenixFlyZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.toriphoenix.TenseiNoSoen2ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.toriphoenix.TenseiNoSoenParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class TenseiNoSoenAbility
extends ChargeableAbility {
    public static final TenseiNoSoenAbility INSTANCE = new TenseiNoSoenAbility();
    private static final ParticleEffect PARTICLES1 = new TenseiNoSoenParticleEffect();
    private static final ParticleEffect PARTICLES2 = new TenseiNoSoen2ParticleEffect();

    public TenseiNoSoenAbility() {
        super("Tensei no Soen", AbilityHelper.getDevilFruitCategory());
        this.setMaxChargeTime(5.0);
        this.setMaxCooldown(30.0);
        this.setDescription("While in the air, the user amasses spiraling flames, then slams into the ground, releasing a massive shockwave");
        this.onStartChargingEvent = this::onStartChargingEvent;
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private boolean onStartChargingEvent(PlayerEntity player) {
        if (!PhoenixFlyZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), PhoenixFlyPointAbility.INSTANCE.getName()}));
            return false;
        }
        if (player.field_70122_E) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_ONLY_IN_AIR, new Object[]{this.getName()}));
            return false;
        }
        return true;
    }

    private void duringChargingEvent(PlayerEntity player, int time) {
        if (!PhoenixFlyZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.ABILITY_MESSAGE_NOT_ZOAN_FORM_SINGLE, new Object[]{this.getName(), PhoenixFlyPointAbility.INSTANCE.getName()}));
            this.stopCharging(player);
        }
        PARTICLES1.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        if (!player.field_70122_E && time == 1) {
            this.setChargeTime(1);
            player.field_71075_bZ.field_75100_b = false;
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayerAbilitiesPacket(player.field_71075_bZ));
            player.func_213293_j(player.func_213322_ci().field_72450_a, -100.0, player.func_213322_ci().field_72449_c);
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)player));
            player.field_70143_R = 0.0f;
        }
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        player.field_70143_R = 0.0f;
        PARTICLES2.spawn(player.field_70170_p, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), 0.0, 0.0, 0.0);
        List<LivingEntity> list = WyHelper.getEntitiesNear(player.func_180425_c(), player.field_70170_p, 24.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        list.remove(player);
        for (LivingEntity target : list) {
            target.func_70097_a(ModDamageSource.func_76365_a((PlayerEntity)player), 30.0f);
        }
        return true;
    }
}

