/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.abilities.yami;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.FactionHelper;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.particles.effects.ParticleEffect;
import xyz.pixelatedw.mineminenomi.particles.effects.yami.KurouzuParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;

public class KurouzuAbility
extends ChargeableAbility {
    public static final KurouzuAbility INSTANCE = new KurouzuAbility();
    private static final ParticleEffect PARTICLES = new KurouzuParticleEffect();
    private List<LivingEntity> entities = new ArrayList<LivingEntity>();

    public KurouzuAbility() {
        super("Kurouzu", AbilityHelper.getDevilFruitCategory());
        this.setDescription("Creates a strong gravitational force, that pulls the opponent towards the user");
        this.setMaxCooldown(12.0);
        this.setMaxChargeTime(3.0);
        this.setCancelable();
        this.duringChargingEvent = this::duringChargingEvent;
        this.onEndChargingEvent = this::onEndChargingEvent;
    }

    private void duringChargingEvent(PlayerEntity player, int chargeTimer) {
        RayTraceResult mop = WyHelper.rayTraceBlocksAndEntities((Entity)player, 320.0);
        double i = mop.func_216347_e().field_72450_a;
        double j = mop.func_216347_e().field_72448_b - (double)(mop instanceof EntityRayTraceResult ? 1 : 0);
        double k = mop.func_216347_e().field_72449_c;
        if (chargeTimer % 5 == 0) {
            PARTICLES.spawn(player.field_70170_p, i, j, k, 0.0, 0.0, 0.0);
        }
        this.entities.clear();
        List targets = WyHelper.getEntitiesNear(new BlockPos(i, j, k), player.field_70170_p, 5.0, FactionHelper.getOutsideGroupPredicate((LivingEntity)player), LivingEntity.class);
        targets.remove(player);
        this.entities.addAll(targets);
    }

    private boolean onEndChargingEvent(PlayerEntity player) {
        for (LivingEntity target : this.entities) {
            target.func_70634_a(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            target.func_195064_c(new EffectInstance(Effects.field_76421_d, 200, 5));
            target.func_195064_c(new EffectInstance(Effects.field_76419_f, 200, 5));
            target.func_195064_c(new EffectInstance(Effects.field_76440_q, 200, 5));
            target.func_195064_c(new EffectInstance(ModEffects.ABILITY_OFF, 200, 1, false, false, false));
        }
        return true;
    }
}

