/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.crew;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;
import xyz.pixelatedw.mineminenomi.init.ModJollyRogers;

public class JollyRogerElement
extends ForgeRegistryEntry<JollyRogerElement> {
    private boolean canBeColored = false;
    private String color = "#FFFFFF";
    private ResourceLocation texture;
    private List<ICanUse> canUseChecks = new ArrayList<ICanUse>();
    private LayerType type;

    @Deprecated
    public JollyRogerElement(LayerType type) {
        this.type = type;
    }

    public JollyRogerElement(LayerType type, String texture) {
        this.type = type;
        String category = "bases";
        if (type == LayerType.BACKGROUND) {
            category = "backgrounds";
        } else if (type == LayerType.DETAIL) {
            category = "details";
        }
        this.setTexture(new ResourceLocation("mineminenomi", "textures/jolly_rogers/" + category + "/" + texture + ".png"));
        ModJollyRogers.registerElement(this);
    }

    public boolean canBeColored() {
        return this.canBeColored;
    }

    public JollyRogerElement setCanBeColored() {
        this.canBeColored = true;
        return this;
    }

    public String getColor() {
        return this.color;
    }

    public JollyRogerElement setColor(String color) {
        this.color = color;
        return this;
    }

    public ResourceLocation getTexture() {
        return this.texture;
    }

    public JollyRogerElement setTexture(ResourceLocation texture) {
        this.texture = texture;
        return this;
    }

    public JollyRogerElement addUseCheck(ICanUse check) {
        this.canUseChecks.add(check);
        return this;
    }

    public boolean canUse(PlayerEntity player) {
        boolean flag = true;
        for (ICanUse check : this.canUseChecks) {
            if (check == null || check.canUse(player)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    public LayerType getLayerType() {
        return this.type;
    }

    public boolean equals(Object element) {
        if (!(element instanceof JollyRogerElement) || this.getTexture() == null || ((JollyRogerElement)((Object)element)).getTexture() == null) {
            return false;
        }
        return this.getTexture().toString().equalsIgnoreCase(((JollyRogerElement)((Object)element)).getTexture().toString());
    }

    @Nullable
    public JollyRogerElement create() {
        try {
            return (JollyRogerElement)((Object)((Object)((Object)this)).getClass().getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static enum LayerType {
        BASE,
        BACKGROUND,
        DETAIL;

    }

    public static interface ICanUse
    extends Serializable {
        public boolean canUse(PlayerEntity var1);
    }
}

