/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SPlayEntityEffectPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.CoolBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.GustSwordAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.HeatBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.ThunderBallAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.WeatherEggAbility;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.FogTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.MirageTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.RainTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderLanceTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderboltTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.ThunderstormTempo;
import xyz.pixelatedw.mineminenomi.abilities.artofweather.tempos.WeatherCloudTempo;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.AntiMannerKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.BienCuitGrillShotAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ConcasseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.DiableJambeAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ExtraHachisAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.PartyTableKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.SkywalkAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.GenkotsuMeteorAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.HakaiHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.JishinHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.KingPunchAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SpinningBrawlAbility;
import xyz.pixelatedw.mineminenomi.abilities.brawler.SuplexAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.DopingAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.FailedExperimentAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.FirstAidAbility;
import xyz.pixelatedw.mineminenomi.abilities.doctor.MedicBagExplosionAbility;
import xyz.pixelatedw.mineminenomi.abilities.ito.SoraNoMichiAbility;
import xyz.pixelatedw.mineminenomi.abilities.rokushiki.GeppoAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.KaenBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.KemuriBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.NemuriBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.RenpatsuNamariBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.SakuretsuSabotenBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.TetsuBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.sniper.TokuyoAburaBoshiAbility;
import xyz.pixelatedw.mineminenomi.abilities.supa.SparClawAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.HiryuKaenAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.OTatsumakiAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.SanbyakurokujuPoundHoAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.ShiShishiSonsonAbility;
import xyz.pixelatedw.mineminenomi.abilities.swordsman.YakkodoriAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityUnlock;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.events.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.events.HakiExpEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.ItemsHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.effects.GuardingEffect;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.mixins.EffectInstanceMixin;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SUpdateEquippedAbilityPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ChargeableAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.ContinuousAbility;
import xyz.pixelatedw.mineminenomi.wypi.abilities.RepeaterAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class AbilityHelper {
    public static final Predicate<Entity> HAS_LOGIA_INVULNERABILITY = entity -> {
        boolean isNotSpectating = EntityPredicates.field_180132_d.test(entity);
        boolean isLogia = false;
        if (entity instanceof LivingEntity) {
            IDevilFruit props = DevilFruitCapability.get((LivingEntity)entity);
            isLogia = props.isLogia() && !props.hasDevilFruit(ModAbilities.YAMI_YAMI_NO_MI);
        }
        return isNotSpectating && isLogia;
    };

    public static void enableAbilities(PlayerEntity player, Predicate<Ability> check) {
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        for (Ability ability : abilityData.getEquippedAbilities(check)) {
            if (ability == null || !ability.isDisabled()) continue;
            ability.startCooldown(player);
            if (player.field_70170_p.field_72995_K) continue;
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, ability), (LivingEntity)player);
        }
    }

    public static void disableAbilities(PlayerEntity player, int duration, Predicate<Ability> check) {
        IAbilityData abilityData = AbilityDataCapability.get((LivingEntity)player);
        for (Ability ability : abilityData.getEquippedAbilities(check)) {
            if (ability == null || ability.isDisabled()) continue;
            if (ability instanceof ContinuousAbility && ability.getState() == Ability.State.CONTINUOUS) {
                ((ContinuousAbility)ability).stopContinuity(player);
            }
            if (ability instanceof RepeaterAbility && ability.getState() == Ability.State.CONTINUOUS) {
                ((RepeaterAbility)ability).setRepeaterCount(((RepeaterAbility)ability).getMaxRepeaterCount());
            }
            if (ability instanceof ChargeableAbility && ability.getState() == Ability.State.CHARGING) {
                ((ChargeableAbility)ability).setChargeTime(((ChargeableAbility)ability).getMaxChargeTime() / 20);
                ability.startCooldown(player);
            }
            ability.startDisable(duration);
            if (player.field_70170_p.field_72995_K) continue;
            WyNetwork.sendToAllTrackingAndSelf(new SUpdateEquippedAbilityPacket(player, ability), (LivingEntity)player);
        }
    }

    public static boolean canUseMomentumAbility(PlayerEntity player) {
        return player.func_110148_a(ModAttributes.JUMP_HEIGHT).func_111126_e() > 0.0 && !player.func_70027_ad();
    }

    public static void setAirJumps(PlayerEntity player, int value) {
        SkywalkAbility SkyWalk;
        SoraNoMichiAbility soraNoMichi;
        GeppoAbility geppo = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(GeppoAbility.INSTANCE);
        if (geppo != null) {
            geppo.airJumps = value;
        }
        if ((soraNoMichi = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SoraNoMichiAbility.INSTANCE)) != null) {
            soraNoMichi.airJumps = value;
        }
        if ((SkyWalk = AbilityDataCapability.get((LivingEntity)player).getEquippedAbility(SkywalkAbility.INSTANCE)) != null) {
            SkyWalk.airJumps = value;
        }
    }

    @Nullable
    public static AbilityOverlay getCurrentOverlay(PlayerEntity player) {
        Ability[] list;
        AbilityOverlay overlay = null;
        for (Ability ability : list = AbilityDataCapability.get((LivingEntity)player).getEquippedAbilities()) {
            if (ability == null || ability instanceof ContinuousAbility && !ability.isContinuous()) continue;
            if (ability instanceof IPunchOverlayAbility) {
                overlay = ((IPunchOverlayAbility)((Object)ability)).getPunchOverlay((LivingEntity)player);
                continue;
            }
            if (!(ability instanceof IBodyOverlayAbility)) continue;
            overlay = ((IBodyOverlayAbility)((Object)ability)).getBodyOverlay();
        }
        return overlay;
    }

    public static boolean placeBlockIfAllowed(World world, double posX, double posY, double posZ, Block toPlace, BlockProtectionRule rule) {
        return AbilityHelper.placeBlockIfAllowed(world, posX, posY, posZ, toPlace, 2, rule);
    }

    public static boolean placeBlockIfAllowed(World world, double posX, double posY, double posZ, Block toPlace, int flag, BlockProtectionRule rule) {
        BlockPos pos = new BlockPos(posX, posY, posZ);
        if (World.func_189509_E((BlockPos)pos)) {
            return false;
        }
        BlockState currentBlockState = world.func_180495_p(pos);
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        boolean inProtectedAreaFlag = worldData.isInsideRestrictedArea((int)posX, (int)posY, (int)posZ);
        boolean isGriefDisabled = !CommonConfig.INSTANCE.isAbilityGriefingEnabled();
        boolean isGriefBypass = rule.getBypassGriefRule();
        if (!isGriefBypass && inProtectedAreaFlag || !isGriefBypass && isGriefDisabled) {
            return false;
        }
        if (rule.check(world, pos, currentBlockState)) {
            BlockState state = toPlace.func_176223_P();
            WyHelper.setBlockStateInChunk(world, pos, state, flag);
            return true;
        }
        return false;
    }

    public static void causeDamageWithPiercing(LivingEntity target, DamageSource source, float damage, float pierce) {
        if (source.func_76363_c()) {
            target.func_70097_a(source, damage);
            return;
        }
        DamageSource piercingSource = source instanceof IndirectEntityDamageSource ? new IndirectEntityDamageSource(source.func_76355_l(), source.func_76364_f(), source.func_76346_g()).func_76348_h() : (source instanceof EntityDamageSource ? new EntityDamageSource(source.func_76355_l(), source.func_76346_g()).func_76348_h() : new DamageSource(source.func_76355_l()).func_76348_h());
        if (source.func_76347_k()) {
            piercingSource.func_76361_j();
        }
        if (source.func_94541_c()) {
            piercingSource.func_94540_d();
        }
        if (source.func_76352_a()) {
            piercingSource.func_76349_b();
        }
        target.func_70097_a(piercingSource, damage * pierce);
        target.field_70172_ad = 0;
        target.field_70737_aN = 0;
        target.func_70097_a(source, damage * (1.0f - pierce));
    }

    public static List<BlockPos> createEmptyCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    if (x != -sizeX && x != sizeX && y != -sizeY && y != sizeY && z != -sizeZ && z != sizeZ) continue;
                    BlockPos pos = new BlockPos(posX + (double)x, posY + (double)y, posZ + (double)z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, posX + (double)x, posY + (double)y, posZ + (double)z, blockToPlace, rule)) continue;
                    blockPositions.add(pos);
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createFilledCube(World world, double posX, double posY, double posZ, int sizeX, int sizeY, int sizeZ, Block blockToPlace, BlockProtectionRule rule) {
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int x = -sizeX; x <= sizeX; ++x) {
            for (int y = -sizeY; y <= sizeY; ++y) {
                for (int z = -sizeZ; z <= sizeZ; ++z) {
                    BlockPos pos = new BlockPos(posX + (double)x, posY + (double)y, posZ + (double)z);
                    if (!AbilityHelper.placeBlockIfAllowed(world, posX + (double)x, posY + (double)y, posZ + (double)z, blockToPlace, rule)) continue;
                    blockPositions.add(pos);
                }
            }
        }
        return blockPositions;
    }

    public static List<BlockPos> createSphere(World world, BlockPos center, int radius, boolean hollow, Block block, int flags, BlockProtectionRule rule) {
        int x0 = center.func_177958_n();
        int y0 = center.func_177956_o();
        int z0 = center.func_177952_p();
        ArrayList<BlockPos> blockPositions = new ArrayList<BlockPos>();
        for (int y = y0 - radius; y <= y0 + radius; ++y) {
            for (int x = x0 - radius; x <= x0 + radius; ++x) {
                for (int z = z0 - radius; z <= z0 + radius; ++z) {
                    BlockPos pos;
                    double distance = (x0 - x) * (x0 - x) + (z0 - z) * (z0 - z) + (y0 - y) * (y0 - y);
                    if (!(distance < (double)(radius * radius)) || hollow && distance < (double)((radius - 1) * (radius - 1)) || !AbilityHelper.placeBlockIfAllowed(world, (pos = new BlockPos(x, y, z)).func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), block, flags, rule)) continue;
                    blockPositions.add(pos);
                }
            }
        }
        return blockPositions;
    }

    @Deprecated
    public static List<BlockPos> createEmptySphere(World world, int posX, int posY, int posZ, int size, Block block, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, new BlockPos(posX, posY, posZ), size, true, block, 2, rule);
    }

    @Deprecated
    public static List<BlockPos> createFilledSphere(World world, int posX, int posY, int posZ, int size, Block block, BlockProtectionRule rule) {
        return AbilityHelper.createSphere(world, new BlockPos(posX, posY, posZ), size, false, block, 2, rule);
    }

    public static double[] propulsion(LivingEntity entity, double extraMX, double extraMZ) {
        double mX = (double)(-MathHelper.func_76126_a((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
        double mZ = (double)(MathHelper.func_76134_b((float)(entity.field_70177_z / 180.0f * (float)Math.PI)) * MathHelper.func_76134_b((float)(entity.field_70125_A / 180.0f * (float)Math.PI))) * 0.4;
        double f2 = MathHelper.func_76133_a((double)(mX * mX + entity.func_213322_ci().field_72448_b * entity.func_213322_ci().field_72448_b + mZ * mZ));
        mX /= f2;
        mZ /= f2;
        mX += entity.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
        mZ += entity.field_70170_p.field_73012_v.nextGaussian() * (double)0.0075f * 1.0;
        return new double[]{mX *= extraMX, mZ *= extraMZ};
    }

    public static ExplosionAbility newExplosion(Entity entity, World world, double posX, double posY, double posZ, float size) {
        return new ExplosionAbility(entity, world, posX, posY, posZ, size);
    }

    public static boolean canUseBrawlerAbilities(LivingEntity entity) {
        return entity.func_184614_ca().func_190926_b();
    }

    public static boolean canUseSwordsmanAbilities(LivingEntity entity) {
        if (entity instanceof PlayerEntity) {
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            IDevilFruit devilFruitProps = DevilFruitCapability.get(entity);
            SparClawAbility sparClawAbility = abilityProps.getEquippedAbility(SparClawAbility.INSTANCE);
            boolean hasSwordInHand = ItemsHelper.isSword(entity.func_184614_ca());
            boolean hasSparClaw = devilFruitProps.hasDevilFruit(ModAbilities.SUPA_SUPA_NO_MI) && sparClawAbility != null && sparClawAbility.isContinuous();
            return hasSwordInHand || hasSparClaw;
        }
        boolean hasSwordInHand = ItemsHelper.isSword(entity.func_184614_ca());
        return hasSwordInHand;
    }

    @Deprecated
    public static boolean checkForRestriction(World world, int posX, int posY, int posZ) {
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        return worldData.isInsideRestrictedArea(posX, posY, posZ);
    }

    public static boolean isAffectedByWater(LivingEntity entity) {
        boolean isUnderWater = entity.func_213290_a(FluidTags.field_206959_a, true);
        boolean waterAbove = entity.field_70170_p.func_180495_p(entity.func_180425_c().func_177984_a()).func_177230_c() == Blocks.field_150355_j;
        boolean inWater = entity.field_70170_p.func_180495_p(entity.func_180425_c()).func_177230_c() == Blocks.field_150355_j;
        boolean waterUnder = entity.field_70170_p.func_180495_p(entity.func_180425_c().func_177977_b()).func_177230_c() == Blocks.field_150355_j;
        int total = 0;
        if (waterAbove) {
            ++total;
        }
        if (inWater) {
            ++total;
        }
        if (waterUnder) {
            ++total;
        }
        boolean hasWaterUnder = entity.func_70090_H() && total >= 2;
        return entity.func_184187_bx() == null && (isUnderWater || hasWaterUnder);
    }

    public static boolean isNearbyKairoseki(PlayerEntity player) {
        return WyHelper.isBlockNearby((LivingEntity)player, 1, ModBlocks.KAIROSEKI, ModBlocks.KAIROSEKI_ORE, ModBlocks.KAIROSEKI_BARS) || ItemsHelper.hasKairosekiItem(player) || AbilityHelper.isAffectedByWater((LivingEntity)player);
    }

    public static boolean verifyIfAbilityIsBanned(Ability a) {
        for (String str : CommonConfig.INSTANCE.getBannedAbilities()) {
            if (!WyHelper.getResourceName(str).contains(WyHelper.getResourceName(a.getName()))) continue;
            return true;
        }
        return false;
    }

    public static Predicate<Ability> getAbilityFromCategoryPredicate(APIConfig.AbilityCategory category) {
        return ability -> {
            if (ability.getUnlockType() == AbilityUnlock.COMMAND) {
                return false;
            }
            return ability.getCategory() == category;
        };
    }

    public static void validateDevilFruitMoves(PlayerEntity player) {
        if (!CommonConfig.INSTANCE.isAbilityFraudChecksEnabled()) {
            return;
        }
        IDevilFruit devilFruitProps = DevilFruitCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        abilityProps.clearUnlockedAbilities(AbilityHelper.getAbilityFromCategoryPredicate(AbilityHelper.getDevilFruitCategory()));
        if (WyHelper.isNullOrEmpty(devilFruitProps.getDevilFruit())) {
            return;
        }
        ItemStack df = DevilFruitHelper.getDevilFruitItem(devilFruitProps.getDevilFruit());
        if (df != null && !df.func_190926_b()) {
            if (devilFruitProps.hasYamiPower()) {
                ItemStack yami = DevilFruitHelper.getDevilFruitItem("yami_yami");
                Ability[] abilityArray = ((AkumaNoMiItem)yami.func_77973_b()).abilities;
                int n = abilityArray.length;
                for (int i = 0; i < n; ++i) {
                    Ability a = abilityArray[i];
                    if (AbilityHelper.verifyIfAbilityIsBanned(a)) continue;
                    abilityProps.addUnlockedAbility(a);
                }
            }
            for (Ability a : ((AkumaNoMiItem)df.func_77973_b()).abilities) {
                if (AbilityHelper.verifyIfAbilityIsBanned(a)) continue;
                abilityProps.addUnlockedAbility(a);
            }
        }
    }

    public static void validateRacialMoves(PlayerEntity player) {
        if (!CommonConfig.INSTANCE.isAbilityFraudChecksEnabled()) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        abilityProps.clearUnlockedAbilities(AbilityHelper.getAbilityFromCategoryPredicate(AbilityHelper.getRacialCategory()));
        DorikiEvent e = new DorikiEvent(player, 0);
        MinecraftForge.EVENT_BUS.post((Event)e);
        Predicate<Ability> abilityRemoveHakiCheck = ability -> {
            if (ability.getUnlockType() == AbilityUnlock.COMMAND) {
                return false;
            }
            return ability.getCategory() == AbilityHelper.getHakiCategory();
        };
        abilityProps.clearUnlockedAbilities(abilityRemoveHakiCheck);
        HakiExpEvent e2 = new HakiExpEvent(player, 0.0f);
        MinecraftForge.EVENT_BUS.post((Event)e2);
    }

    public static void validateStyleMoves(PlayerEntity player) {
        if (!CommonConfig.INSTANCE.isAbilityFraudChecksEnabled()) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        Predicate<Ability> abilityRemoveCheck = ability -> {
            if (ability.getUnlockType() == AbilityUnlock.COMMAND) {
                return false;
            }
            return ability.getCategory() == AbilityHelper.getStyleCategory();
        };
        abilityProps.clearUnlockedAbilities(abilityRemoveCheck);
        if (props.isSwordsman()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.SWORDSMAN_TRIAL_01, ShiShishiSonsonAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SWORDSMAN_TRIAL_02, YakkodoriAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SWORDSMAN_TRIAL_03, SanbyakurokujuPoundHoAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SWORDSMAN_TRIAL_04, OTatsumakiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SWORDSMAN_TRIAL_05, HiryuKaenAbility.INSTANCE);
        } else if (props.isSniper()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_01, KaenBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_02, KemuriBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_03, TokuyoAburaBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_03, TetsuBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_04, SakuretsuSabotenBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_05, NemuriBoshiAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.SNIPER_TRIAL_06, RenpatsuNamariBoshiAbility.INSTANCE);
        } else if (props.isDoctor()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.DOCTOR_TRIAL_01, FirstAidAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.DOCTOR_TRIAL_02, FailedExperimentAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.DOCTOR_TRIAL_03, MedicBagExplosionAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.DOCTOR_TRIAL_03, DopingAbility.INSTANCE);
        } else if (props.isWeatherWizard()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_01, HeatBallAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_01, CoolBallAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_01, WeatherCloudTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_02, ThunderBallAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_02, ThunderboltTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_02, RainTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_02, MirageTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_02, FogTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_03, ThunderstormTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_03, ThunderLanceTempo.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_04, GustSwordAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.ART_OF_WEATHER_TRIAL_04, WeatherEggAbility.INSTANCE);
        } else if (props.isBlackLeg()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_01, ConcasseAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_02, ExtraHachisAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_03, AntiMannerKickCourseAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_03, PartyTableKickCourseAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_04, SkywalkAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_05, DiableJambeAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BLACK_LEG_TRIAL_05, BienCuitGrillShotAbility.INSTANCE);
        } else if (props.isBrawler()) {
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_01, SuplexAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_02, SpinningBrawlAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_03, GenkotsuMeteorAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_04, HakaiHoAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_05, JishinHoAbility.INSTANCE);
            AbilityHelper.validateQuestAbility(player, ModQuests.BRAWLER_TRIAL_06, KingPunchAbility.INSTANCE);
        }
    }

    public static void validateFactionMoves(PlayerEntity player) {
        if (!CommonConfig.INSTANCE.isAbilityFraudChecksEnabled()) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        ArrayList<Object> tempAblList = new ArrayList<Object>();
        if (props.isMarine()) {
            for (Ability a : ModAbilities.MARINE_ABILITIES) {
                if (!abilityProps.hasUnlockedAbility(a) || AbilityHelper.verifyIfAbilityIsBanned(a)) continue;
                tempAblList.add((Object)a);
            }
        }
        abilityProps.clearUnlockedAbilities(AbilityHelper.getAbilityFromCategoryPredicate(AbilityHelper.getFactionCategory()));
        for (Ability ability : tempAblList) {
            abilityProps.addUnlockedAbility(ability);
        }
        tempAblList.clear();
    }

    private static void validateQuestAbility(PlayerEntity player, Quest quest, Ability ability) {
        IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
        IQuestData questProps = QuestDataCapability.get(player);
        if (CommonConfig.INSTANCE.isQuestProgressionEnabled()) {
            if (questProps.hasFinishedQuest(quest) && !AbilityHelper.verifyIfAbilityIsBanned(ability)) {
                abilityProps.addUnlockedAbility(ability);
            }
        } else if (!AbilityHelper.verifyIfAbilityIsBanned(ability)) {
            abilityProps.addUnlockedAbility(ability);
        }
    }

    @Deprecated
    public static boolean isEntityInRoom(Entity entity) {
        int roomSize = 30;
        for (int i = -roomSize; i < roomSize; ++i) {
            for (int j = -roomSize; j < roomSize; ++j) {
                for (int k = -roomSize; k < roomSize; ++k) {
                    double distance;
                    if (entity.field_70170_p.func_180495_p(new BlockPos(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)).func_177230_c() != ModBlocks.OPE_MID || !((distance = entity.func_70092_e(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)) < (double)((roomSize - 1) * (roomSize - 1)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Deprecated
    public static boolean isInsideTorikago(Entity entity) {
        int roomSize = 36;
        for (int i = -roomSize; i < roomSize; ++i) {
            for (int j = -roomSize; j < roomSize; ++j) {
                for (int k = -roomSize; k < roomSize; ++k) {
                    double distance;
                    if (entity.field_70170_p.func_180495_p(new BlockPos(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)).func_177230_c() != ModBlocks.STRING_MID || !((distance = entity.func_70092_e(entity.func_226277_ct_() + (double)i, entity.func_226278_cu_() + (double)j, entity.func_226281_cx_() + (double)k)) < (double)((roomSize - 1) * (roomSize - 1)))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isTargetBlockingAbility(PlayerEntity player, LivingEntity target) {
        return player.func_70651_bq().stream().anyMatch(instance -> instance.func_188419_a() instanceof GuardingEffect) || HakiHelper.hasAnyHakiEnabled(target) && (double)HakiHelper.getBusoHardeningHakiExp((LivingEntity)player) > (double)HakiHelper.getBusoHardeningHakiExp(target) + WyHelper.randomWithRange(-1, 7);
    }

    public static void addFrostbite(LivingEntity target, LivingEntity player, int duration) {
        EffectInstance effect = target.func_70660_b(ModEffects.FROSTBITE);
        EffectInstance frozen = target.func_70660_b(ModEffects.FROZEN);
        if (frozen != null) {
            return;
        }
        EffectInstance instance = new EffectInstance(ModEffects.FROSTBITE, duration, 0);
        if (effect == null) {
            target.func_195064_c(instance);
        } else {
            ((EffectInstanceMixin)effect).setDuration(effect.func_76459_b() + duration);
        }
        if (player instanceof ServerPlayerEntity) {
            ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SPlayEntityEffectPacket(target.func_145782_y(), effect == null ? instance : effect));
        }
    }

    public static void reduceEffect(EffectInstance effect, int reduction) {
        if (effect == null) {
            return;
        }
        try {
            int duration = effect.func_76459_b() / reduction;
            ((EffectInstanceMixin)effect).setDuration(duration);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Deprecated
    public static boolean isBlockInsideRoom(LivingEntity entity, BlockPos vector3d) {
        for (int i = -20; i < 20; ++i) {
            for (int j = -20; j < 20; ++j) {
                for (int k = -20; k < 20; ++k) {
                    if (entity.field_70170_p.func_180495_p(new BlockPos(vector3d.func_177958_n() + i, vector3d.func_177956_o() + j, vector3d.func_177952_p() + k)).func_177230_c() != ModBlocks.OPE_MID) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void slowEntityFall(LivingEntity player) {
        AbilityHelper.slowEntityFall(player, 5);
    }

    public static void slowEntityFall(LivingEntity player, int duration) {
        player.func_195064_c(new EffectInstance(ModEffects.REDUCED_FALL, duration, 0));
    }

    public static boolean isJumping(LivingEntity entity) {
        Field f = ObfuscationReflectionHelper.findField(LivingEntity.class, (String)"field_70703_bu");
        try {
            return f.getBoolean(entity);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void setPose(LivingEntity entity, Pose pose) {
        Method method = ObfuscationReflectionHelper.findMethod(Entity.class, (String)"func_213301_b", (Class[])new Class[]{Pose.class});
        try {
            method.setAccessible(true);
            method.invoke((Object)entity, pose);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static APIConfig.AbilityCategory getDevilFruitCategory() {
        return APIConfig.AbilityCategory.valueOf("DEVIL_FRUIT");
    }

    public static APIConfig.AbilityCategory getRacialCategory() {
        return APIConfig.AbilityCategory.valueOf("RACIAL");
    }

    public static APIConfig.AbilityCategory getStyleCategory() {
        return APIConfig.AbilityCategory.valueOf("STYLE");
    }

    public static APIConfig.AbilityCategory getHakiCategory() {
        return APIConfig.AbilityCategory.valueOf("HAKI");
    }

    public static APIConfig.AbilityCategory getFactionCategory() {
        return APIConfig.AbilityCategory.valueOf("FACTION");
    }

    public static APIConfig.AbilityCategory getEquipmentCategory() {
        return APIConfig.AbilityCategory.valueOf("EQUIPMENT");
    }
}

