/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ShootableItem;
import net.minecraft.item.SwordItem;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.abilities.ZoomAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModArmors;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEnchantments;
import xyz.pixelatedw.mineminenomi.init.ModItemTags;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.items.weapons.ClimaTactItem;
import xyz.pixelatedw.mineminenomi.items.weapons.CoreSwordItem;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class ItemsHelper {
    private static String[] wantedPostersBackgrounds = new String[]{"forest1", "forest2", "jungle1", "jungle2", "hills1", "hills2", "hills3", "plains1", "plains2", "plains3", "taiga1", "taiga2"};

    public static void dropWantedPosters(World world, int posX, int posY, int posZ) {
        ExtendedWorldData worldData = ExtendedWorldData.get(world);
        if (worldData.getAllBounties().size() <= 0) {
            return;
        }
        ArrayList bountiesInPackage = new ArrayList();
        Predicate<PlayerEntity> hasBounty = player -> player != null && player.func_70089_S() && BountyHelper.canGainBounty(player) && worldData.getBounty(player.func_110124_au().toString().toLowerCase()) != 0L;
        WyHelper.getEntitiesNear(new BlockPos(posX, posY, posZ), world, 10.0, PlayerEntity.class).stream().filter(hasBounty).limit(5L).forEach(player -> {
            AbstractMap.SimpleEntry<String, Long> se = new AbstractMap.SimpleEntry<String, Long>(player.func_110124_au().toString(), worldData.getBounty(player.func_110124_au().toString().toLowerCase()));
            bountiesInPackage.add(se);
        });
        if (bountiesInPackage.size() < 5) {
            bountiesInPackage.addAll(worldData.getAllBounties().entrySet().stream().filter(entry -> !bountiesInPackage.contains(entry)).limit(3L).collect(Collectors.toList()));
        }
        bountiesInPackage.stream().forEach(entry -> {
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER);
            CompoundNBT data = ItemsHelper.setWantedData(world, (String)entry.getKey(), (Long)entry.getValue());
            if (!data.isEmpty()) {
                stack.func_77982_d(data);
                world.func_217376_c((Entity)new ItemEntity(world, (double)posX, (double)(posY + 1), (double)posZ, stack));
            }
        });
    }

    public static CompoundNBT setWantedData(World world, String id, long bounty) {
        CompoundNBT data = new CompoundNBT();
        PlayerEntity player = world.func_217371_b(UUID.fromString(id));
        if (player == null) {
            return data;
        }
        data.func_74778_a("UUID", id);
        data.func_74778_a("Name", player.func_200200_C_().func_150254_d());
        data.func_74772_a("Bounty", bounty);
        data.func_74778_a("Faction", EntityStatsCapability.get((LivingEntity)player).getFaction());
        int randomBg = (int)WyHelper.randomWithRange(0, wantedPostersBackgrounds.length - 1);
        data.func_74778_a("Background", wantedPostersBackgrounds[randomBg]);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        String dateString = format.format(new Date());
        data.func_74778_a("Date", dateString);
        CompoundNBT compoundnbt = new CompoundNBT();
        NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)player.func_146103_bH());
        data.func_218657_a("Owner", (INBT)compoundnbt);
        return data;
    }

    public static boolean isBow(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        if (itemStack.func_77975_n() == UseAction.BOW) {
            return true;
        }
        return itemStack.func_77973_b() instanceof ShootableItem;
    }

    public static boolean isSword(ItemStack itemStack) {
        return !itemStack.func_190926_b() && (itemStack.func_77973_b() instanceof SwordItem || itemStack.func_77973_b() instanceof CoreSwordItem && !((CoreSwordItem)itemStack.func_77973_b()).isBlunt());
    }

    public static boolean isClimaTact(ItemStack itemStack) {
        if (itemStack.func_190926_b()) {
            return false;
        }
        return itemStack.func_77973_b() instanceof ClimaTactItem;
    }

    public static boolean hasKairosekiItem(PlayerEntity player) {
        ImmutableList allInventories = ImmutableList.of((Object)player.field_71071_by.field_70462_a, (Object)player.field_71071_by.field_70460_b, (Object)player.field_71071_by.field_184439_c);
        for (List list : allInventories) {
            boolean hasMatch = list.stream().anyMatch(stack -> !stack.func_190926_b() && ModItemTags.KAIROSEKI.func_199685_a_((Object)stack.func_77973_b()));
            if (!hasMatch) continue;
            return true;
        }
        return false;
    }

    public static boolean isKairosekiWeapon(ItemStack heldItem) {
        if (heldItem != null) {
            return heldItem.func_77948_v() && EnchantmentHelper.func_77506_a((Enchantment)ModEnchantments.KAIROSEKI, (ItemStack)heldItem) > 0 || heldItem.func_77973_b() == ModWeapons.JITTE;
        }
        return false;
    }

    public static float getSniperInaccuracy(float inaccuracy, PlayerEntity player) {
        if (EntityStatsCapability.get((LivingEntity)player).isSniper() && player.func_184582_a(EquipmentSlotType.HEAD).func_77973_b() == ModArmors.SNIPER_GOGGLES) {
            boolean isActive;
            IAbilityData aprops = AbilityDataCapability.get((LivingEntity)player);
            ZoomAbility ability = aprops.getEquippedAbility(ZoomAbility.INSTANCE);
            boolean bl = isActive = ability != null && ability.isContinuous();
            if (isActive) {
                return inaccuracy / 4.0f;
            }
        }
        return inaccuracy;
    }

    public static float getItemDamage(ItemStack stack) {
        Multimap multimap = stack.func_111283_C(EquipmentSlotType.MAINHAND);
        double modifier = EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        for (Map.Entry entry : multimap.entries()) {
            AttributeModifier attr = (AttributeModifier)entry.getValue();
            if (!attr.func_111167_a().equals(UUID.fromString("cb3f55d3-645c-4f38-a497-9c13a33db5cf"))) continue;
            double damage = attr.func_111164_d() + modifier + 1.0;
            return (float)damage;
        }
        return -1.0f;
    }
}

