/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.api.helpers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.awt.Color;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.gui.GuiUtils;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRoger;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class RendererHelper {
    private static final float distance = (float)(Math.sqrt(3.0) / 2.0);

    public static void drawAbilityIcon(String iconName, int x, int y, int u, int v) {
        RendererHelper.drawAbilityIcon(iconName, x, y, 1, u, v);
    }

    public static void drawAbilityIcon(String iconName, int x, int y, int z, int u, int v) {
        RendererHelper.drawAbilityIcon(iconName, x, y, z, u, v, 1.0f, 1.0f, 1.0f);
    }

    public static void drawAbilityIcon(String iconName, int x, int y, int z, int u, int v, float red, float green, float blue) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("mineminenomi", "textures/abilities/" + WyHelper.getResourceName(iconName) + ".png"));
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_227851_o_);
        bufferbuilder.func_225582_a_((double)x, (double)(y + v), (double)z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)(y + v), (double)z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)y, (double)z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, (double)z).func_227885_a_(red, green, blue, 1.0f).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawDevilFruitIcon(String iconName, int x, int y, int u, int v) {
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(new ResourceLocation("mineminenomi", "textures/items/" + WyHelper.getResourceName(iconName) + ".png"));
        BufferBuilder bufferbuilder = Tessellator.func_178181_a().func_178180_c();
        bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferbuilder.func_225582_a_((double)x, (double)(y + v), 1.0).func_225583_a_(0.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)(y + v), 1.0).func_225583_a_(1.0f, 1.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)(x + u), (double)y, 1.0).func_225583_a_(1.0f, 0.0f).func_181675_d();
        bufferbuilder.func_225582_a_((double)x, (double)y, 1.0).func_225583_a_(0.0f, 0.0f).func_181675_d();
        Tessellator.func_178181_a().func_78381_a();
    }

    public static void drawQuad(MatrixStack matrixStack, IVertexBuilder buffer, float red, float green, float blue, float alpha, float x, float y, float u, float v) {
        MatrixStack.Entry entry = matrixStack.func_227866_c_();
        Matrix4f matrix4f = entry.func_227870_a_();
        Matrix3f matrix3f = entry.func_227872_b_();
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x, y + u, 0.0f, 1.0f);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x + u, y + v, 1.0f, 1.0f);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x + u, y, 1.0f, 0.0f);
        RendererHelper.drawVertex(matrix4f, matrix3f, buffer, red, green, blue, alpha, x, y, 0.0f, 0.0f);
    }

    public static void drawVertex(Matrix4f matrixPos, Matrix3f matrixNormal, IVertexBuilder bufferIn, float red, float green, float blue, float alpha, float x, float y, float texU, float texV) {
        bufferIn.func_227888_a_(matrixPos, x, y, 0.0f).func_227885_a_(red, green, blue, alpha).func_225583_a_(texU, texV).func_227891_b_(OverlayTexture.field_229196_a_).func_227886_a_(0xF000F0).func_227887_a_(matrixNormal, 0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public static void drawPlayerJollyRoger(JollyRoger jollyRoger, MatrixStack matrixStack, IRenderTypeBuffer buffer) {
        Color color;
        float alpha;
        float blue;
        float green;
        for (JollyRogerElement element : jollyRoger.getBackgrounds()) {
            if (element == null || element.getTexture() == null) continue;
            float red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
            alpha = 1.0f;
            if (element.canBeColored()) {
                color = WyHelper.hexToRGB(element.getColor());
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(element.getTexture())), red, green, blue, alpha, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        if (jollyRoger.getBase() != null && jollyRoger.getBase().getTexture() != null) {
            float red = 1.0f;
            float green2 = 1.0f;
            float blue2 = 1.0f;
            float alpha2 = 1.0f;
            if (jollyRoger.getBase().canBeColored()) {
                Color color2 = WyHelper.hexToRGB(jollyRoger.getBase().getColor());
                red = (float)color2.getRed() / 255.0f;
                green2 = (float)color2.getGreen() / 255.0f;
                blue2 = (float)color2.getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(jollyRoger.getBase().getTexture())), red, green2, blue2, alpha2, 0.0f, 0.0f, 1.0f, 1.0f);
        }
        for (JollyRogerElement element : jollyRoger.getDetails()) {
            if (element == null || element.getTexture() == null) continue;
            float red = 1.0f;
            green = 1.0f;
            blue = 1.0f;
            alpha = 1.0f;
            if (element.canBeColored()) {
                color = WyHelper.hexToRGB(element.getColor());
                red = (float)color.getRed() / 255.0f;
                green = (float)color.getGreen() / 255.0f;
                blue = (float)color.getBlue() / 255.0f;
            }
            RendererHelper.drawQuad(matrixStack, buffer.getBuffer(ModRenderTypes.getWantedPoster(element.getTexture())), red, green, blue, alpha, 0.0f, 0.0f, 1.0f, 1.0f);
        }
    }

    public static void drawPlayerJollyRoger(JollyRoger jollyRoger) {
        Color color;
        int i;
        for (JollyRogerElement element : jollyRoger.getBackgrounds()) {
            i = 0;
            if (element != null && element.getTexture() != null) {
                if (element.canBeColored()) {
                    color = WyHelper.hexToRGB(element.getColor());
                    RenderSystem.color3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                } else {
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(element.getTexture());
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)i);
            }
            --i;
        }
        if (jollyRoger.getBase() != null && jollyRoger.getBase().getTexture() != null) {
            if (jollyRoger.getBase().canBeColored()) {
                Color color2 = WyHelper.hexToRGB(jollyRoger.getBase().getColor());
                RenderSystem.color3f((float)((float)color2.getRed() / 255.0f), (float)((float)color2.getGreen() / 255.0f), (float)((float)color2.getBlue() / 255.0f));
            } else {
                RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
            }
            Minecraft.func_71410_x().func_110434_K().func_110577_a(jollyRoger.getBase().getTexture());
            GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        }
        for (JollyRogerElement element : jollyRoger.getDetails()) {
            i = 0;
            if (element != null && element.getTexture() != null) {
                if (element.canBeColored()) {
                    color = WyHelper.hexToRGB(element.getColor());
                    RenderSystem.color3f((float)((float)color.getRed() / 255.0f), (float)((float)color.getGreen() / 255.0f), (float)((float)color.getBlue() / 255.0f));
                } else {
                    RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(element.getTexture());
                GuiUtils.drawTexturedModalRect((int)0, (int)0, (int)0, (int)0, (int)256, (int)256, (float)i);
            }
            ++i;
        }
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
    }

    public static void drawA(IVertexBuilder vertexBuilder, Matrix4f matrix4f, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, 0.0f, 0.0f).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawB(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float xz, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, -distance * xz, y, -0.5f * xz).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawC(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float xz, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, distance * xz, y, -0.5f * xz).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }

    public static void drawD(IVertexBuilder vertexBuilder, Matrix4f matrix4f, float y, float z, Color color) {
        vertexBuilder.func_227888_a_(matrix4f, 0.0f, y, z).func_225586_a_(color.getRed(), color.getGreen(), color.getBlue(), color.getAlpha()).func_181675_d();
    }
}

