/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.blocks;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;

public class OilSpillBlock
extends Block {
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private int ticks = 400;

    public OilSpillBlock() {
        super(Block.Properties.func_200945_a((Material)Material.field_151598_x).func_200941_a(0.98f).func_200943_b(0.5f).func_200947_a(SoundType.field_185859_l).func_200944_c());
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean isFullCube(BlockState state) {
        return false;
    }

    public boolean func_196260_a(BlockState state, IWorldReader world, BlockPos pos) {
        return world.func_180495_p(pos.func_177977_b()).func_200132_m();
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return !stateIn.func_196955_c((IWorldReader)worldIn, currentPos) ? Blocks.field_150350_a.func_176223_P() : stateIn;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return adjacentBlockState.func_177230_c() == this;
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
    }

    public void func_196262_a(BlockState state, World worldIn, BlockPos pos, Entity entity) {
        float x = (float)Math.min(1.5, entity.func_213322_ci().field_72450_a * (double)1.15f);
        float z = (float)Math.min(1.5, entity.func_213322_ci().field_72449_c * (double)1.15f);
        entity.func_213293_j((double)x, entity.func_213322_ci().field_72448_b, (double)z);
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random rand) {
        if (world.field_72995_K) {
            return;
        }
        if (this.ticks > 0) {
            --this.ticks;
            if (this.areFlamesClose((World)world, pos)) {
                world.func_217398_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 3.0f, true, CommonConfig.INSTANCE.isAbilityGriefingEnabled() ? Explosion.Mode.DESTROY : Explosion.Mode.NONE);
            }
        } else {
            world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
            this.ticks = 400 + rand.nextInt(10);
        }
        world.func_205220_G_().func_205362_a(pos, (Object)this, 10, TickPriority.EXTREMELY_HIGH);
    }

    private boolean areFlamesClose(World world, BlockPos pos) {
        int range = 2;
        for (int i = -range; i < range; ++i) {
            for (int j = -range; j < range; ++j) {
                for (int k = -range; k < range; ++k) {
                    double posZ;
                    double posY;
                    double posX = pos.func_177958_n() + i;
                    Block currentBlock = world.func_180495_p(new BlockPos(posX, posY = (double)(pos.func_177956_o() + j), posZ = (double)(pos.func_177952_p() + k))).func_177230_c();
                    if (currentBlock != Blocks.field_150480_ab) continue;
                    return true;
                }
            }
        }
        return false;
    }
}

