/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.AblProtectionTileEntity;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.packets.server.ability.SViewProtectionPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class AbilityProtectionCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"abilityprotection").requires(source -> source.func_197034_c(3));
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)builder.then(Commands.func_197057_a((String)"new").then(Commands.func_197056_a((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> AbilityProtectionCommand.createProtection((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"size")))))).then(Commands.func_197057_a((String)"resize").then(Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).then(Commands.func_197056_a((String)"size", (ArgumentType)IntegerArgumentType.integer((int)1, (int)100)).executes(context -> AbilityProtectionCommand.resizeProtection((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id"), IntegerArgumentType.getInteger((CommandContext)context, (String)"size"))))))).then(Commands.func_197057_a((String)"view").then(Commands.func_197056_a((String)"state", (ArgumentType)BoolArgumentType.bool()).executes(context -> AbilityProtectionCommand.viewProtection((CommandContext<CommandSource>)context, BoolArgumentType.getBool((CommandContext)context, (String)"state")))))).then(Commands.func_197057_a((String)"list").executes(context -> AbilityProtectionCommand.listProtections((CommandContext<CommandSource>)context)))).then(Commands.func_197057_a((String)"remove").then(Commands.func_197056_a((String)"id", (ArgumentType)IntegerArgumentType.integer()).executes(context -> AbilityProtectionCommand.deleteProtection((CommandContext<CommandSource>)context, IntegerArgumentType.getInteger((CommandContext)context, (String)"id")))));
        dispatcher.register(builder);
    }

    private static int resizeProtection(CommandContext<CommandSource> context, int id, int size) throws CommandSyntaxException {
        int midZ;
        int midY;
        int[] maxPos;
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        int[][] area = worldData.getAllRestrictions().get(--id);
        int[] minPos = area[0];
        int midX = (minPos[0] + (maxPos = area[1])[0]) / 2;
        BlockPos pos = new BlockPos(midX, midY = (minPos[1] + maxPos[1]) / 2, midZ = (minPos[2] + maxPos[2]) / 2);
        BlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() == ModBlocks.ABILITY_PROTECTION) {
            AblProtectionTileEntity tile = (AblProtectionTileEntity)world.func_175625_s(pos);
            tile.resizeProtection((PlayerEntity)player, pos, id, size);
        }
        return 1;
    }

    private static int deleteProtection(CommandContext<CommandSource> context, int id) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        int[][] area = worldData.getAllRestrictions().get(--id);
        int[] minPos = area[0];
        int[] maxPos = area[1];
        int midX = (minPos[0] + maxPos[0]) / 2;
        int midY = (minPos[1] + maxPos[1]) / 2;
        int midZ = (minPos[2] + maxPos[2]) / 2;
        BlockPos pos = new BlockPos(midX, midY, midZ);
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
        worldData.removeRestrictedArea(id);
        return 1;
    }

    private static int listProtections(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        ITextComponent list = new StringTextComponent("Protection Sites: \n\n").func_150255_a(new Style().func_150238_a(TextFormatting.GREEN));
        int i = 1;
        for (int[][] area : worldData.getAllRestrictions()) {
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0) continue;
            int midX = (minPos[0] + maxPos[0]) / 2;
            int midY = (minPos[1] + maxPos[1]) / 2;
            int midZ = (minPos[2] + maxPos[2]) / 2;
            Style style = new Style().func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/tp @p " + midX + " " + midY + " " + midZ));
            list.func_150257_a(new StringTextComponent(i + ". x=" + midX + ", y=" + midY + ", z=" + midZ + "\n").func_150255_a(style));
            ++i;
        }
        ((CommandSource)context.getSource()).func_197030_a(list, true);
        return 1;
    }

    private static int viewProtection(CommandContext<CommandSource> context, boolean state) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        for (int[][] area : worldData.getAllRestrictions()) {
            int[] minPos = area[0];
            int[] maxPos = area[1];
            if (minPos.length <= 0 || maxPos.length <= 0) continue;
            int midX = (minPos[0] + maxPos[0]) / 2;
            int midY = (minPos[1] + maxPos[1]) / 2;
            int midZ = (minPos[2] + maxPos[2]) / 2;
            int[] midPoint = new int[]{midX, midY, midZ};
            AblProtectionTileEntity te = (AblProtectionTileEntity)world.func_175625_s(new BlockPos(midPoint[0], midPoint[1], midPoint[2]));
            if (te == null || !(te instanceof AblProtectionTileEntity)) continue;
            WyNetwork.sendTo(new SViewProtectionPacket(state, midPoint, te.getSize()), (PlayerEntity)player);
        }
        return 1;
    }

    private static int createProtection(CommandContext<CommandSource> context, int size) throws CommandSyntaxException {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        Vec3d vec = ((CommandSource)context.getSource()).func_197036_d();
        BlockPos pos = new BlockPos(vec);
        world.func_175656_a(pos, ModBlocks.ABILITY_PROTECTION.func_176223_P());
        ((AblProtectionTileEntity)world.func_175625_s(pos)).setupProtection((PlayerEntity)player, pos, size);
        return 1;
    }
}

