/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.io.File;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.crew.Crew;
import xyz.pixelatedw.mineminenomi.api.crew.JollyRogerElement;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.HakiHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CustomSpawnerTileEntity;
import xyz.pixelatedw.mineminenomi.challenges.Challenge;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.ChallengesDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.challenges.IChallengesData;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModChallenges;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncChallengeDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.APIConfig;
import xyz.pixelatedw.mineminenomi.wypi.APIRegistries;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class FGCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"fg").requires(source -> source.func_197034_c(0));
        builder.then(Commands.func_197057_a((String)"info").executes(context -> FGCommand.showInfo((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check_haki").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FGCommand.checkHakiStats((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> FGCommand.checkHakiStats((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"check_crews").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FGCommand.checkCrews((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target"))))).executes(context -> FGCommand.checkCrews((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"check_bounties").executes(context -> FGCommand.checkBounties((CommandContext<CommandSource>)context)));
        builder.then(Commands.func_197057_a((String)"check_structures").executes(context -> FGCommand.checkStructures((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"turn_sword_clone").then(Commands.func_197056_a((String)"target", (ArgumentType)EntityArgument.func_197096_c()).executes(context -> FGCommand.turnSwordInClone((CommandContext<CommandSource>)context, EntityArgument.func_197089_d((CommandContext)context, (String)"target")))));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"challenges").then(Commands.func_197057_a((String)"unlock_all").executes(context -> FGCommand.challenges((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), 1)))).then(Commands.func_197057_a((String)"lock_all").executes(context -> FGCommand.challenges((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h(), -1))));
        builder.then(Commands.func_197057_a((String)"drop_package").executes(context -> FGCommand.dropPackage((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"save_structure").then(Commands.func_197056_a((String)"from", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"to", (ArgumentType)BlockPosArgument.func_197276_a()).then(Commands.func_197056_a((String)"name", (ArgumentType)StringArgumentType.word()).executes(context -> FGCommand.saveStructure((CommandContext<CommandSource>)context, BlockPosArgument.func_197274_b((CommandContext)context, (String)"from"), BlockPosArgument.func_197274_b((CommandContext)context, (String)"to"), StringArgumentType.getString((CommandContext)context, (String)"name"), ((CommandSource)context.getSource()).func_197035_h()))))));
        builder.then(Commands.func_197057_a((String)"load_structure").executes(context -> FGCommand.loadStructure((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(Commands.func_197057_a((String)"hardcore").executes(context -> FGCommand.harcoreLoadout((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())));
        builder.then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"stress_test").then(Commands.func_197057_a((String)"spawners").executes(context -> FGCommand.stressTestSpawners((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h())))).then(Commands.func_197057_a((String)"blocks").executes(context -> FGCommand.stressTestBlocks((CommandContext<CommandSource>)context, ((CommandSource)context.getSource()).func_197035_h()))));
        dispatcher.register(builder);
    }

    private static int stressTestBlocks(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        long startTime = System.currentTimeMillis();
        int i = 0;
        try {
            for (int x = -50; x < 50; ++x) {
                for (int y = -50; y < 50; ++y) {
                    for (int z = -50; z < 50; ++z) {
                        WyHelper.setBlockStateInChunk(player.field_70170_p, player.func_180425_c().func_177982_a(x, y, z), Blocks.field_150346_d.func_176223_P(), 2);
                        ++i;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        long stopTime = System.currentTimeMillis();
        System.out.println("Finished generating " + i + " blocks after " + (stopTime - startTime) + " millis");
        return 1;
    }

    private static int stressTestSpawners(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ServerWorld world = player.func_71121_q();
        for (int i = -3; i < 3; ++i) {
            for (int j = -3; j < 3; ++j) {
                BlockPos pos = player.func_180425_c().func_177982_a(i, 0, j);
                world.func_175656_a(pos, ModBlocks.CUSTOM_SPAWNER.func_176223_P());
                CustomSpawnerTileEntity spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos);
                spawner.setSpawnerLimit(5);
                spawner.setSpawnerMob(ModEntities.MARINE_WITH_SWORD);
            }
        }
        return 1;
    }

    private static int checkStructures(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        int[] arr = StructuresHelper.STRUCTURES_COUNT;
        int sum = 0;
        for (int i : arr) {
            sum += i;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("========SHIPS==================================\n\n");
        builder.append("Small Pirate Ships: " + arr[0] + "\n");
        builder.append("Medium Pirate Ships: " + arr[1] + "\n");
        builder.append("Large Pirate Ships: " + arr[2] + "\n");
        builder.append("Marine Battleships: " + arr[3] + "\n");
        builder.append("Ghost Ships: " + arr[4] + "\n\n");
        builder.append("========LAND STRUCTURES========================\n\n");
        builder.append("Marine Small Base: " + arr[5] + "\n");
        builder.append("Marine Large Base: " + arr[6] + "\n");
        builder.append("Bandit Small Base: " + arr[7] + "\n");
        builder.append("Bandit Large Base: " + arr[8] + "\n");
        builder.append("Dojos: " + arr[9] + "\n");
        builder.append("Marine Camp: " + arr[12] + "\n");
        builder.append("Bandit Camp: " + arr[13] + "\n");
        builder.append("Marine Watch Tower: " + arr[10] + "\n");
        builder.append("========SKY STRUCTURES========================\n\n");
        builder.append("Sky Islands: " + arr[11] + "\n");
        builder.append("Total: " + sum + "\n");
        builder.append("===============================================");
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(builder.toString()), true);
        return 1;
    }

    private static int dropPackage(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        BountyHelper.issueBountyForAllPlayers(player.field_70170_p);
        WantedPosterPackageEntity posterPackage = new WantedPosterPackageEntity(player.field_70170_p);
        posterPackage.func_70080_a(player.func_226277_ct_(), player.func_226278_cu_() + 5.0, player.func_226281_cx_(), 0.0f, 0.0f);
        player.field_70170_p.func_217376_c((Entity)posterPackage);
        return 1;
    }

    private static int harcoreLoadout(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)ModAbilities.YOMI_YOMI_NO_MI));
        player.field_71071_by.func_70441_a(new ItemStack((IItemProvider)Blocks.field_150346_d, 64));
        player.func_71024_bL().func_75114_a(0);
        player.func_71024_bL().func_75119_b(0.0f);
        return 1;
    }

    private static String convertToCSV(String[] data) {
        return Stream.of(data).map(FGCommand::escapeSpecialCharacters).collect(Collectors.joining(","));
    }

    private static String escapeSpecialCharacters(String data) {
        String escapedData = data.replaceAll("\\R", " ");
        if (data.contains(",") || data.contains("\"") || data.contains("'")) {
            data = data.replace("\"", "\"\"");
            escapedData = "\"" + data + "\"";
        }
        return escapedData;
    }

    private static String getOriginFruit(Ability ability) {
        for (AkumaNoMiItem fruit : ModValues.devilfruits) {
            for (Ability abl : fruit.abilities) {
                if (!abl.equals((Object)ability)) continue;
                return fruit.getDevilFruitName();
            }
        }
        return "";
    }

    private static int showInfo(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        player.func_145747_a((ITextComponent)new StringTextComponent("A total of " + ModValues.devilfruits.size() + " Devil Fruits have been registered"));
        player.func_145747_a((ITextComponent)new StringTextComponent("A total of " + APIRegistries.ABILITIES.getEntries().size() + " abilities have been registered"));
        StringBuilder builder = new StringBuilder();
        builder.append("\n\u00a7aAbilities without descriptions:\u00a7r");
        for (Ability abl : APIRegistries.ABILITIES.getValues()) {
            if (abl.getDescription() != null || abl.isHideInGUI()) continue;
            builder.append("  " + abl.getDisplayName() + "\n");
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(builder.toString()));
        builder = new StringBuilder();
        builder.append("\u00a7aAbilities without textures:\u00a7r");
        for (Ability abl : APIRegistries.ABILITIES.getValues()) {
            if (abl.isHideInGUI()) continue;
            String texture = abl.hasCustomTexture() ? WyHelper.getResourceName(abl.getCustomTexture()) : WyHelper.getResourceName(abl.getName());
            try {
                boolean hasFile = new File(APIConfig.getResourceFolderPath() + "/assets/" + "mineminenomi" + "/textures/abilities/" + texture + ".png").exists();
                if (hasFile) continue;
                builder.append("  " + abl.getDisplayName() + "\n");
            }
            catch (Exception e) {
                e.printStackTrace();
                break;
            }
        }
        player.func_145747_a((ITextComponent)new StringTextComponent(builder.toString()));
        return 1;
    }

    private static int loadStructure(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        WyHelper.loadNBTStructure((ServerWorld)player.field_70170_p, "marine/small_base", player.func_180425_c());
        player.func_145747_a((ITextComponent)new StringTextComponent("Done"));
        return 1;
    }

    private static int saveStructure(CommandContext<CommandSource> context, BlockPos from, BlockPos to, String name, ServerPlayerEntity player) {
        for (int i = from.func_177958_n(); i < to.func_177958_n(); ++i) {
            for (int j = from.func_177956_o(); j < to.func_177956_o(); ++j) {
                for (int k = from.func_177952_p(); k < to.func_177952_p(); ++k) {
                    BlockPos pos = new BlockPos(i, j, k);
                    BlockState state = player.field_70170_p.func_180495_p(pos);
                    if (state.func_196959_b((IProperty)BlockStateProperties.field_208198_y)) {
                        state = (BlockState)state.func_206870_a((IProperty)BlockStateProperties.field_208198_y, (Comparable)Boolean.valueOf(false));
                        player.field_70170_p.func_175656_a(pos, state);
                    }
                    if (state.func_177230_c() == Blocks.field_150355_j || state.func_177230_c() == Blocks.field_189881_dj) {
                        player.field_70170_p.func_180501_a(pos, Blocks.field_150350_a.func_176223_P(), 18);
                    }
                    if (state.func_177230_c() != Blocks.field_222422_lK) continue;
                    Direction dir = (Direction)state.func_177229_b((IProperty)BlockStateProperties.field_208155_H);
                    BlockState newState = ModBlocks.DESIGN_BARREL.func_176223_P();
                    newState = (BlockState)newState.func_206870_a((IProperty)BlockStateProperties.field_208155_H, (Comparable)dir);
                    player.field_70170_p.func_175656_a(pos, newState);
                }
            }
        }
        if (player.field_70170_p instanceof ServerWorld) {
            BlockPos size = to.func_177973_b((Vec3i)from);
            System.out.println("From: /tp " + from.func_177958_n() + " " + from.func_177956_o() + " " + from.func_177952_p());
            System.out.println("To: /tp " + to.func_177958_n() + " " + to.func_177956_o() + " " + to.func_177952_p());
            System.out.println("size: " + size);
            ArrayList<Block> bannedBlocks = new ArrayList<Block>();
            bannedBlocks.add(Blocks.field_150355_j);
            WyHelper.saveNBTStructure((ServerWorld)player.field_70170_p, name, from, size, bannedBlocks);
            player.func_145747_a((ITextComponent)new StringTextComponent("Done"));
        }
        return 1;
    }

    private static int challenges(CommandContext<CommandSource> context, ServerPlayerEntity player, int op) {
        Challenge[] challenges;
        IChallengesData props = ChallengesDataCapability.get((PlayerEntity)player);
        for (Challenge ch : challenges = new Challenge[]{ModChallenges.GIN, ModChallenges.DON_KRIEG, ModChallenges.MORGAN}) {
            if (op == 1) {
                if (props.hasChallenge(ch)) continue;
                props.addChallenge(ch);
                continue;
            }
            if (op != -1 || !props.hasChallenge(ch)) continue;
            ch.setComplete(false);
            props.removeChallenge(ch);
        }
        WyNetwork.sendTo(new SSyncChallengeDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
        return 1;
    }

    private static int checkBounties(CommandContext<CommandSource> source) {
        ServerWorld world = ((CommandSource)source.getSource()).func_197023_e();
        ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Long> entry : worldData.getAllBounties().entrySet()) {
            UUID uuid = UUID.fromString(entry.getKey());
            PlayerEntity target = world.func_217371_b(uuid);
            sb.append(target.func_145748_c_().func_150254_d() + " " + entry.getValue());
        }
        ((CommandSource)source.getSource()).func_197030_a((ITextComponent)new StringTextComponent(sb.toString()), true);
        return 1;
    }

    private static int checkCrews(CommandContext<CommandSource> source, ServerPlayerEntity target) {
        ExtendedWorldData worldData = ExtendedWorldData.get(target.field_70170_p);
        StringBuilder builder = new StringBuilder();
        for (Crew crew : worldData.getCrews()) {
            builder.append("\n=================\n" + crew.getName() + "\n");
            builder.append("Members: \n");
            for (Crew.Member member : crew.getMembers()) {
                builder.append(" " + member.getUsername() + (member.isCaptain() ? " (Captain)" : "") + "\n");
            }
            builder.append("Details: \n");
            for (JollyRogerElement elem : crew.getJollyRoger().getDetails()) {
                if (elem == null) continue;
                builder.append(" " + elem.getTexture() + "\n");
            }
        }
        target.func_145747_a((ITextComponent)new StringTextComponent(builder.toString()));
        return 1;
    }

    private static int turnSwordInClone(CommandContext<CommandSource> context, ServerPlayerEntity player) {
        ItemStack heldStack = player.func_184614_ca();
        if (!heldStack.func_190926_b()) {
            heldStack.func_196082_o().func_74757_a("isClone", true);
        }
        return 1;
    }

    private static int checkHakiStats(CommandContext<CommandSource> context, ServerPlayerEntity target) {
        IHakiData props = HakiDataCapability.get((LivingEntity)target);
        target.func_145747_a((ITextComponent)new StringTextComponent("Imbuing: " + props.getBusoshokuImbuingHakiExp()));
        target.func_145747_a((ITextComponent)new StringTextComponent("Hardening: " + props.getBusoshokuHardeningHakiExp()));
        target.func_145747_a((ITextComponent)new StringTextComponent("Observation: " + props.getKenbunshokuHakiExp()));
        target.func_145747_a((ITextComponent)new StringTextComponent("Total: " + HakiHelper.getTotalHakiExp((LivingEntity)target)));
        return 1;
    }
}

