/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.commands;

import com.google.common.collect.Lists;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.EntityArgument;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.commands.HakiTypeArgument;
import xyz.pixelatedw.mineminenomi.api.enums.HakiType;
import xyz.pixelatedw.mineminenomi.api.events.HakiExpEvent;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncHakiDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class HakiExpCommand {
    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        LiteralArgumentBuilder builder = (LiteralArgumentBuilder)Commands.func_197057_a((String)"hakiexp").requires(source -> source.func_197034_c(2));
        builder.then(Commands.func_197056_a((String)"type", HakiTypeArgument.hakiType()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"amount", (ArgumentType)FloatArgumentType.floatArg((float)-3.4028235E38f, (float)Float.MAX_VALUE)).executes(context -> HakiExpCommand.alterHakiExp((CommandContext<CommandSource>)context, (HakiType)((Object)((Object)context.getArgument("type", HakiType.class))), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"), HakiExpCommand.getDefaultCollection((CommandContext<CommandSource>)context)))).then(Commands.func_197056_a((String)"targets", (ArgumentType)EntityArgument.func_197094_d()).executes(context -> HakiExpCommand.alterHakiExp((CommandContext<CommandSource>)context, (HakiType)((Object)((Object)context.getArgument("type", HakiType.class))), FloatArgumentType.getFloat((CommandContext)context, (String)"amount"), EntityArgument.func_197090_e((CommandContext)context, (String)"targets"))))));
        dispatcher.register(builder);
    }

    private static Collection<ServerPlayerEntity> getDefaultCollection(CommandContext<CommandSource> context) throws CommandSyntaxException {
        return Lists.newArrayList((Object[])new ServerPlayerEntity[]{((CommandSource)context.getSource()).func_197035_h()});
    }

    private static int alterHakiExp(CommandContext<CommandSource> context, HakiType hakiType, float amount, Collection<ServerPlayerEntity> targets) throws CommandSyntaxException {
        for (ServerPlayerEntity player : targets) {
            IHakiData props = HakiDataCapability.get((LivingEntity)player);
            if (hakiType == HakiType.IMBUING) {
                props.alterBusoshokuImbuingHakiExp(amount);
            } else if (hakiType == HakiType.HARDENING) {
                props.alterBusoshokuHardeningHakiExp(amount);
            } else if (hakiType == HakiType.KENBUNSHOKU) {
                props.alterKenbunshokuHakiExp(amount);
            }
            WyNetwork.sendTo(new SSyncHakiDataPacket(player.func_145782_y(), props), (PlayerEntity)player);
            HakiExpEvent e = new HakiExpEvent((PlayerEntity)player, amount);
            if (MinecraftForge.EVENT_BUS.post((Event)e)) {
                return 1;
            }
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(TextFormatting.GREEN + "" + (amount > 0.0f ? "+" : "") + amount + " haki exp for " + player.func_145748_c_().func_150254_d()), true);
        }
        return 1;
    }
}

