/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class PhysicalBodyEntity
extends OPEntity {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(PhysicalBodyEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private Ability parentAbility = null;

    public PhysicalBodyEntity(World world) {
        super(ModEntities.PHYSICAL_BODY, world);
    }

    public void setParentAbility(Ability ability) {
        this.parentAbility = ability;
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public UUID getOwnerUUID() {
        return (UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get();
    }

    public PlayerEntity getOwner() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        PlayerEntity owner = this.getOwner();
        if (owner == null) {
            return false;
        }
        owner.func_70097_a(DamageSource.field_76376_m, amount);
        this.func_70606_j(owner.func_110143_aJ());
        return super.func_70097_a(source, amount);
    }

    @Override
    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            IAbilityData abilityProps;
            Ability parentAbilityInstance;
            PlayerEntity owner = this.getOwner();
            boolean hasParentAbilityActive = false;
            if (owner != null && (parentAbilityInstance = (abilityProps = AbilityDataCapability.get((LivingEntity)owner)).getEquippedAbility(this.parentAbility)) != null && parentAbilityInstance.isContinuous()) {
                hasParentAbilityActive = true;
            }
            if (owner == null || !owner.func_70089_S() || this.parentAbility == null || !hasParentAbilityActive) {
                this.func_70106_y();
                return;
            }
        }
        super.func_70071_h_();
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(OWNER, null);
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(100.0);
        this.func_110148_a(SharedMonsterAttributes.field_111266_c).func_111128_a(1.0);
    }

    @Override
    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (this.field_70180_af.func_187225_a(OWNER) != null) {
            compound.func_74778_a("OwnerUUID", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
    }

    @Override
    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("OwnerUUID"))));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

