/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.animals;

import java.util.Arrays;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.fluid.IFluidState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.mobs.IDynamicRenderer;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class YagaraBullEntity
extends AnimalEntity
implements IDynamicRenderer {
    private static final DataParameter<Optional<UUID>> OWNER = EntityDataManager.func_187226_a(YagaraBullEntity.class, (IDataSerializer)DataSerializers.field_187203_m);
    private static final DataParameter<Boolean> IS_SADDLED = EntityDataManager.func_187226_a(YagaraBullEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> TEXTURE_ID = EntityDataManager.func_187226_a(YagaraBullEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final Item[] SADDLES = new Item[]{Items.field_151141_av};
    private static final Item[] TAMING_FOOD = new Item[]{Items.field_196088_aY};
    private static final Item[] FOOD = new Item[]{Items.field_196102_ba, Items.field_196104_bb, Items.field_196086_aW, Items.field_196087_aX, Items.field_196089_aZ, Items.field_196088_aY};
    private String[] textures = new String[]{"yagara_bull1", "yagara_bull2", "yagara_bull3"};
    private double waterLevel;

    public YagaraBullEntity(World world) {
        super(ModEntities.YAGARA_BULL, world);
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 8.0f));
        this.field_70714_bg.func_75776_a(2, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.25, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_196088_aY}), true));
        this.field_70714_bg.func_75776_a(4, (Goal)new RandomSwimmingGoal((CreatureEntity)this, 1.5, 80));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(40.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.05f);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(LivingEntity.SWIM_SPEED).func_111128_a(8.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.func_184212_Q().func_187214_a(OWNER, Optional.empty());
        this.func_184212_Q().func_187214_a(IS_SADDLED, (Object)false);
        this.func_184212_Q().func_187214_a(TEXTURE_ID, (Object)0);
    }

    public void func_70071_h_() {
        if (this.checkInWater()) {
            double d2 = (this.waterLevel - this.func_174813_aQ().field_72338_b) / (double)this.func_213302_cg();
            this.func_70050_g(30);
            if (this.func_208600_a(FluidTags.field_206959_a) || this.field_70170_p.func_180495_p(this.func_180425_c().func_177984_a()).func_177230_c() == Blocks.field_150355_j) {
                d2 = 0.5;
            }
            if (d2 > 0.0) {
                Vec3d vec3d1 = this.func_213322_ci();
                this.func_213293_j(vec3d1.field_72450_a, (vec3d1.field_72448_b + d2 * 0.02) * 0.75, vec3d1.field_72449_c);
            }
        }
        super.func_70071_h_();
    }

    private boolean checkInWater() {
        AxisAlignedBB axisalignedbb = this.func_174813_aQ();
        int i = MathHelper.func_76128_c((double)axisalignedbb.field_72340_a);
        int j = MathHelper.func_76143_f((double)axisalignedbb.field_72336_d);
        int k = MathHelper.func_76128_c((double)axisalignedbb.field_72338_b);
        int l = MathHelper.func_76143_f((double)(axisalignedbb.field_72338_b + 0.001));
        int i1 = MathHelper.func_76128_c((double)axisalignedbb.field_72339_c);
        int j1 = MathHelper.func_76143_f((double)axisalignedbb.field_72334_f);
        boolean flag = false;
        this.waterLevel = Double.MIN_VALUE;
        try (BlockPos.PooledMutable blockpos$pooledmutableblockpos = BlockPos.PooledMutable.func_185346_s();){
            for (int k1 = i; k1 < j; ++k1) {
                for (int l1 = k; l1 < l; ++l1) {
                    for (int i2 = i1; i2 < j1; ++i2) {
                        blockpos$pooledmutableblockpos.func_181079_c(k1, l1, i2);
                        IFluidState ifluidstate = this.field_70170_p.func_204610_c((BlockPos)blockpos$pooledmutableblockpos);
                        if (!ifluidstate.func_206884_a(FluidTags.field_206959_a)) continue;
                        float f = (float)l1 + ifluidstate.func_215679_a((IBlockReader)this.field_70170_p, (BlockPos)blockpos$pooledmutableblockpos);
                        this.waterLevel = Math.max((double)f, this.waterLevel);
                        flag |= axisalignedbb.field_72338_b < (double)f;
                    }
                }
            }
        }
        return flag;
    }

    public boolean func_70104_M() {
        return true;
    }

    public double func_70042_X() {
        return 0.5;
    }

    public boolean func_82171_bF() {
        return this.func_184179_bs() instanceof LivingEntity;
    }

    protected boolean func_225502_at_() {
        return false;
    }

    protected boolean func_184219_q(Entity passenger) {
        return this.func_184188_bt().size() < 2 && !this.func_208600_a(FluidTags.field_206959_a);
    }

    public float func_205022_a(BlockPos pos, IWorldReader world) {
        boolean flag1 = false;
        for (int i = 1; i < 3; ++i) {
            BlockState state = world.func_180495_p(pos.func_177979_c(i));
            if (state.func_185904_a() != Material.field_151586_h) continue;
            flag1 = true;
            break;
        }
        boolean flag2 = pos.func_177956_o() < 150;
        float weight = 64 / pos.func_177956_o() * 10;
        return flag1 && flag2 ? weight : 0.0f;
    }

    public boolean func_213380_a(IWorld world, SpawnReason reason) {
        BlockPos pos = new BlockPos((Entity)this);
        float weight = this.func_205022_a(pos, (IWorldReader)world);
        return weight > 0.0f;
    }

    protected void mountTo(PlayerEntity player) {
        if (!this.field_70170_p.field_72995_K) {
            player.field_70177_z = this.field_70177_z;
            player.field_70125_A = this.field_70125_A;
            player.func_184220_m((Entity)this);
        }
    }

    public void func_184232_k(Entity passenger) {
        super.func_184232_k(passenger);
        if (passenger instanceof MobEntity) {
            MobEntity mobentity = (MobEntity)passenger;
            this.field_70761_aq = mobentity.field_70761_aq;
        }
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (this.textures != null && this.textures.length > 0) {
            this.setTexture(this.field_70146_Z.nextInt(this.textures.length));
        }
        return spawnData;
    }

    public void func_213352_e(Vec3d vec) {
        if (this.func_70089_S()) {
            if (this.func_184207_aI() && this.func_82171_bF() && this.isSaddled()) {
                LivingEntity livingentity = (LivingEntity)this.func_184179_bs();
                this.field_70126_B = this.field_70177_z = livingentity.field_70177_z;
                this.field_70125_A = livingentity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70759_as = this.field_70761_aq = this.field_70177_z;
                float f = livingentity.field_70702_br * 0.2f;
                float f1 = livingentity.field_191988_bg;
                if (this.func_184186_bw()) {
                    this.func_70659_e((float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
                    super.func_213352_e(new Vec3d((double)f, vec.field_72448_b, (double)f1));
                } else if (livingentity instanceof PlayerEntity) {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
            } else {
                super.func_213352_e(vec);
            }
        }
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        Optional<Item> tropicalFish;
        ItemStack stack;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.isTamed() && player == this.getOwner() && hand == Hand.MAIN_HAND) {
            ItemStack stack2 = player.func_184614_ca();
            if (!stack2.func_190926_b()) {
                Optional<Item> food = Arrays.stream(FOOD).filter(x -> stack2.func_77973_b() == x).findFirst();
                Optional<Item> saddle = Arrays.stream(SADDLES).filter(x -> stack2.func_77973_b() == x).findFirst();
                if (food.isPresent() && this.func_110143_aJ() < this.func_110138_aP()) {
                    stack2.func_190918_g(1);
                    this.func_70691_i(4.0f);
                    this.spawnHeartParticles();
                    return true;
                }
                if (saddle.isPresent() && !this.isSaddled()) {
                    this.setSaddled(true);
                    stack2.func_190918_g(1);
                }
            } else {
                this.mountTo(player);
            }
        } else if (!this.isTamed() && hand == Hand.MAIN_HAND && !(stack = player.func_184614_ca()).func_190926_b() && (tropicalFish = Arrays.stream(TAMING_FOOD).filter(x -> stack.func_77973_b() == x).findFirst()).isPresent()) {
            stack.func_190918_g(1);
            double chance = this.field_70146_Z.nextDouble();
            if (chance < 0.35) {
                this.spawnHeartParticles();
                this.setOwner(player.func_110124_au());
            }
        }
        return false;
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        if (((Optional)this.field_70180_af.func_187225_a(OWNER)).isPresent()) {
            compound.func_74778_a("owner", ((UUID)((Optional)this.field_70180_af.func_187225_a(OWNER)).get()).toString());
        }
        compound.func_74757_a("isSaddled", ((Boolean)this.field_70180_af.func_187225_a(IS_SADDLED)).booleanValue());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        if (!WyHelper.isNullOrEmpty(compound.func_74779_i("owner"))) {
            this.field_70180_af.func_187227_b(OWNER, Optional.of(UUID.fromString(compound.func_74779_i("owner"))));
        }
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)compound.func_74767_n("isSaddled"));
    }

    public boolean func_213397_c(double distance) {
        return !this.isTamed();
    }

    public void spawnHeartParticles() {
        for (int i = 0; i < 5; ++i) {
            double offsetX = WyHelper.randomDouble() / 2.0;
            double offsetY = WyHelper.randomDouble() / 2.0;
            double offsetZ = WyHelper.randomDouble() / 2.0;
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + 1.0 + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    public void setSaddled(boolean flag) {
        this.field_70180_af.func_187227_b(IS_SADDLED, (Object)flag);
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SADDLED);
    }

    public void setOwner(UUID uuid) {
        this.field_70180_af.func_187227_b(OWNER, Optional.of(uuid));
    }

    public PlayerEntity getOwner() {
        return ((Optional)this.func_184212_Q().func_187225_a(OWNER)).isPresent() ? this.field_70170_p.func_217371_b((UUID)((Optional)this.func_184212_Q().func_187225_a(OWNER)).get()) : null;
    }

    public boolean isTamed() {
        return this.getOwner() != null;
    }

    public int getTextureId() {
        return (Integer)this.func_184212_Q().func_187225_a(TEXTURE_ID);
    }

    protected void setTexture(int texture) {
        this.func_184212_Q().func_187227_b(TEXTURE_ID, (Object)texture);
    }

    @Override
    public String getMobTexture() {
        return this.textures[this.getTextureId()];
    }

    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return null;
    }

    @Override
    public String getDefaultTexture() {
        return this.textures[0];
    }
}

