/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.goals.abilities;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.util.DamageSource;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.entities.mobs.goals.CooldownGoal;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class CleaveAttackGoal
extends CooldownGoal {
    private OPEntity entity;
    private int hitCount;
    private int maxCount;
    private int duration;
    private int maxDuration;
    private float prevHealth;
    private int animationId;
    private int distance;
    private float knockbackPower = 1.5f;
    private boolean canBreakBlocks;

    public CleaveAttackGoal(OPEntity entity, int cooldown, int hitCount, int distance, boolean canBreakBlocks) {
        super(entity, cooldown, (int)WyHelper.randomWithRange(5, 10));
        this.entity = entity;
        this.maxCount = hitCount;
        this.prevHealth = this.entity.func_110143_aJ();
        this.canBreakBlocks = canBreakBlocks;
        this.distance = distance;
        this.maxDuration = 7;
        this.entity.addThreat(2 + (this.canBreakBlocks ? 1 : 0));
    }

    public CleaveAttackGoal(OPEntity entity, int cooldown, int hitCount, int distance) {
        this(entity, cooldown, hitCount, distance, false);
    }

    public CleaveAttackGoal setAnimationId(int id) {
        this.animationId = id;
        return this;
    }

    public CleaveAttackGoal setKnockbackPower(float power) {
        this.knockbackPower = power;
        return this;
    }

    @Override
    public boolean func_75250_a() {
        boolean hasDistance;
        if (this.entity.func_110143_aJ() < this.prevHealth) {
            ++this.hitCount;
            this.prevHealth = this.entity.func_110143_aJ();
        }
        boolean shouldExecute = super.func_75250_a() || this.hitCount >= this.maxCount;
        boolean hasMovement = !this.entity.func_70644_a(ModEffects.MOVEMENT_BLOCKED);
        boolean hasTarget = this.entity.func_70638_az() != null;
        boolean bl = hasDistance = hasTarget && this.entity.func_70032_d((Entity)this.entity.func_70638_az()) < (float)this.distance;
        return shouldExecute && hasMovement && hasTarget && hasDistance;
    }

    @Override
    public void endCooldown() {
        super.endCooldown();
        this.entity.setCurrentGoal(null);
        this.entity.setPreviousGoal(this);
        this.duration = 0;
    }

    public boolean func_75253_b() {
        ++this.duration;
        boolean continueExecution = false;
        if (this.duration < this.maxDuration) {
            continueExecution = true;
        }
        if (!continueExecution) {
            this.entity.setAnimation(0);
            this.hitCount = 0;
            this.maxCount = (int)Math.abs(WyHelper.randomWithRange(this.maxCount - 2, this.maxCount + 2));
            this.entity.setCurrentGoal(this);
            this.setOnCooldown(true);
        }
        return continueExecution;
    }

    public void func_75249_e() {
        this.entity.setAnimation(this.animationId);
        List<LivingEntity> targets = WyHelper.getEntitiesNear(this.entity.func_180425_c(), this.entity.field_70170_p, (double)this.distance, LivingEntity.class);
        targets.remove(this.entity);
        float damage = (float)this.entity.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        for (LivingEntity target : targets) {
            target.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.entity), damage);
            double x = target.func_226277_ct_() - this.entity.func_226277_ct_();
            double z = target.func_226281_cx_() - this.entity.func_226281_cx_();
            while (x * x + z * z < 1.0E-4) {
                x = (Math.random() - Math.random()) * 0.01;
                z = (Math.random() - Math.random()) * 0.01;
            }
            target.func_70653_a((Entity)target, this.knockbackPower, -x, -z);
            if (!this.canBreakBlocks) continue;
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.entity, this.entity.field_70170_p, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), 1.5f);
            explosion.setDamageEntities(false);
            explosion.setExplosionSound(false);
            explosion.doExplosion();
        }
    }
}

