/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.mobs.marines;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.RangedAttackGoal;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.mobs.marines.AbstractMarineEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.CannonBallProjectile;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModWeapons;
import xyz.pixelatedw.mineminenomi.particles.effects.common.CommonExplosionParticleEffect;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

public class MarineBomberEntity
extends AbstractMarineEntity
implements IRangedAttackMob {
    private static final String[] DEFAULT_TEXTURES = new String[]{"marine1", "marine2", "marine3", "marine4", "marine5"};

    public MarineBomberEntity(World world) {
        super((EntityType<? extends MobEntity>)ModEntities.MARINE_BOMBER, world, DEFAULT_TEXTURES);
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(1, (Goal)new RangedAttackGoal((IRangedAttackMob)this, 1.0, 200, 30.0f));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(15.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.21f);
        this.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111128_a(2.0);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_188791_g).func_111128_a(2.0);
        this.setDoriki(20.0 + WyHelper.randomWithRange(0, 10));
        this.setBelly(5.0 + WyHelper.randomWithRange(0, 10));
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
    }

    @Override
    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        this.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModWeapons.BAZOOKA));
        return spawnData;
    }

    public void func_82196_d(LivingEntity target, float distance) {
        CannonBallProjectile proj = new CannonBallProjectile(this.field_70170_p, (LivingEntity)this);
        proj.setDamage(proj.getDamage() * 0.8f);
        proj.onBlockImpactEvent = hit -> {
            if (this.field_70173_aa < 0) {
                return;
            }
            ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)proj, this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 2.0f);
            explosion.setStaticDamage(5.0f);
            explosion.setDestroyBlocks(false);
            explosion.setSmokeParticles(new CommonExplosionParticleEffect(2));
            explosion.doExplosion();
        };
        double velX = target.func_226277_ct_() - this.func_226277_ct_();
        double velY = target.func_174813_aQ().field_72338_b - proj.func_226278_cu_();
        double velZ = target.func_226281_cx_() - this.func_226281_cx_();
        double x = MathHelper.func_76133_a((double)(velX * velX + velZ * velZ));
        proj.func_70186_c(velX, velY + x * (double)0.1f, velZ, 2.0f, MathHelper.func_76125_a((int)(12 - this.field_70170_p.func_175659_aa().func_151525_a() * 4), (int)0, (int)100));
        this.field_70170_p.func_217376_c((Entity)proj);
    }
}

