/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.extra;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.BambooPillarEntity;
import xyz.pixelatedw.mineminenomi.entities.projectiles.extra.ExtraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class PopGreenProjectile
extends AbilityProjectileEntity {
    private PopGreenType type = null;

    public PopGreenProjectile(World world) {
        super(ExtraProjectiles.POP_GREEN, world);
    }

    public PopGreenProjectile(EntityType type, World world) {
        super(type, world);
    }

    public PopGreenProjectile(World world, double x, double y, double z) {
        super(ExtraProjectiles.POP_GREEN, world, x, y, z);
    }

    public PopGreenProjectile(World world, LivingEntity player, PopGreenType type) {
        super(ExtraProjectiles.POP_GREEN, world, player);
        this.type = type;
        this.setDamage(this.type == PopGreenType.IMPACT_WOLF ? 25.0f : 4.0f);
        this.setPhysical(false);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        if (this.type == PopGreenType.IMPACT_WOLF && !this.field_70170_p.field_72995_K) {
            GenericParticleData data;
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 8; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new GenericParticleData(ModParticleTypes.MERA);
                data.setLife(10);
                data.setSize(2.5f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 4; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                data = new GenericParticleData(ModParticleTypes.MERA2);
                data.setLife(7);
                data.setSize(1.0f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }

    private void onBlockImpactEvent(BlockPos block) {
        switch (this.type) {
            case DEVIL: 
            case RAFFLESIA: 
            case HUMANDRAKE: 
            case TRAMPOLIA: {
                break;
            }
            case BAKUHATSU: {
                ExplosionAbility bakuhatsu_explosion = AbilityHelper.newExplosion((Entity)this.field_70192_c, this.field_70170_p, block.func_177958_n(), block.func_177956_o(), block.func_177952_p(), 1.0f);
                bakuhatsu_explosion.setExplosionSound(true);
                bakuhatsu_explosion.setDestroyBlocks(true);
                bakuhatsu_explosion.setFireAfterExplosion(false);
                bakuhatsu_explosion.setDamageOwner(true);
                bakuhatsu_explosion.setDamageEntities(true);
                bakuhatsu_explosion.doExplosion();
                break;
            }
            case IMPACT_WOLF: {
                ExplosionAbility wolf_explosion = AbilityHelper.newExplosion((Entity)this.field_70192_c, this.field_70170_p, block.func_177958_n(), block.func_177956_o(), block.func_177952_p(), 3.0f);
                wolf_explosion.setExplosionSound(true);
                wolf_explosion.setDestroyBlocks(true);
                wolf_explosion.setFireAfterExplosion(true);
                wolf_explosion.setDamageOwner(true);
                wolf_explosion.setDamageEntities(true);
                wolf_explosion.doExplosion();
                break;
            }
        }
    }

    private void onEntityImpactEvent(LivingEntity entity) {
        switch (this.type) {
            case DEVIL: 
            case HUMANDRAKE: {
                break;
            }
            case TAKE_JAVELIN: {
                for (int i = 0; i < 7; ++i) {
                    entity.field_70172_ad = 0;
                    BambooPillarEntity pillar = new BambooPillarEntity(entity.field_70170_p, entity);
                    pillar.field_70125_A = 90.0f;
                    pillar.func_70107_b(entity.func_226277_ct_() + Math.random(), entity.func_226278_cu_(), entity.func_226281_cx_() + Math.random());
                    pillar.func_213293_j(0.0, 0.4, 0.0);
                    entity.field_70170_p.func_217376_c((Entity)pillar);
                    entity.field_70172_ad = 0;
                    entity.func_70097_a(pillar.source, 1.0f);
                }
                break;
            }
            case BAKUHATSU: {
                ExplosionAbility bakuhatsu_explosion = AbilityHelper.newExplosion((Entity)this.field_70192_c, this.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 1.0f);
                bakuhatsu_explosion.setExplosionSound(true);
                bakuhatsu_explosion.setDestroyBlocks(true);
                bakuhatsu_explosion.setFireAfterExplosion(false);
                bakuhatsu_explosion.setDamageOwner(true);
                bakuhatsu_explosion.setDamageEntities(true);
                bakuhatsu_explosion.doExplosion();
                break;
            }
            case TRAMPOLIA: {
                Vec3d speed = WyHelper.propulsion(entity, 2.0, 2.0);
                entity.func_213293_j(speed.field_72450_a, 0.8, speed.field_72449_c);
                entity.field_70133_I = true;
                break;
            }
            case IMPACT_WOLF: {
                ExplosionAbility wolf_explosion = AbilityHelper.newExplosion((Entity)this.field_70192_c, this.field_70170_p, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 3.0f);
                wolf_explosion.setExplosionSound(true);
                wolf_explosion.setDestroyBlocks(true);
                wolf_explosion.setFireAfterExplosion(true);
                wolf_explosion.setDamageOwner(true);
                wolf_explosion.setDamageEntities(true);
                wolf_explosion.doExplosion();
                break;
            }
        }
    }

    public static enum PopGreenType {
        NONE,
        DEVIL,
        RAFFLESIA,
        TAKE_JAVELIN,
        BAKUHATSU,
        HUMANDRAKE,
        TRAMPOLIA,
        IMPACT_WOLF;

    }
}

