/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.gura;

import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.FallingBlockEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.abilities.ExplosionAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.entities.projectiles.gura.GuraProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class GekishinProjectile
extends AbilityProjectileEntity {
    float maxDamage = 50.0f;
    int maxLife = 60;

    public GekishinProjectile(World world) {
        super(GuraProjectiles.GEKISHIN, world);
    }

    public GekishinProjectile(EntityType type, World world) {
        super(type, world);
    }

    public GekishinProjectile(World world, double x, double y, double z) {
        super(GuraProjectiles.GEKISHIN, world, x, y, z);
    }

    public GekishinProjectile(World world, LivingEntity player) {
        super(GuraProjectiles.GEKISHIN, world, player);
        this.setDamage(this.maxDamage);
        this.setMaxLife(this.maxLife);
        this.setCollisionSize(2.0);
        this.setPassThroughEntities();
        this.setDamageSource(this.bypassingSource);
        this.onTickEvent = this::onTickEvent;
    }

    private void onTickEvent() {
        float power = 4.5f - (float)(this.maxLife - this.getLife()) / 15.0f;
        BlockPos pos = null;
        int j = 1;
        this.setDamage(this.maxDamage * (power / 5.0f));
        while (pos == null) {
            BlockState state = this.field_70170_p.func_180495_p(this.func_180425_c().func_177979_c(j));
            if (state.func_200132_m()) {
                pos = this.func_180425_c().func_177979_c(j);
                break;
            }
            if (j > 12) break;
            ++j;
        }
        if (pos == null) {
            this.func_70106_y();
            return;
        }
        for (int i = 0; i < 3; ++i) {
            if (i % 2 == 0) {
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_() + WyHelper.randomDouble() * 1.5, this.func_226278_cu_() + WyHelper.randomDouble() * 1.5, this.func_226281_cx_() + WyHelper.randomDouble() * 1.5, 1, 0.0, 0.0, 0.0, 0.0);
                continue;
            }
            double offsetX = WyHelper.randomDouble() * (double)power;
            double offsetY = WyHelper.randomDouble() * (double)power;
            double offsetZ = WyHelper.randomDouble() * (double)power;
            GenericParticleData data = new GenericParticleData(ModParticleTypes.GURA2);
            data.setLife(10);
            data.setSize(20.0f);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
        }
        int size = 0;
        ExplosionAbility explosion = AbilityHelper.newExplosion((Entity)this.func_85052_h(), this.field_70170_p, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), power);
        explosion.setHeightDifference(45);
        explosion.setStaticBlockResistance(1.35f);
        explosion.setProtectOwnerFromFalling(true);
        explosion.setExplosionSound(false);
        explosion.setSmokeParticles(null);
        explosion.setStaticDamage(10.0f * power);
        explosion.addRemovedBlocksToList();
        explosion.doExplosion();
        for (FallingBlockEntity entity : explosion.removedBlocks) {
            entity.func_213293_j(WyHelper.randomWithRange(-1, 1) / 2.0, 0.5 + WyHelper.randomDouble(), WyHelper.randomWithRange(-1, 1) / 2.0);
            entity.field_70133_I = true;
            entity.field_145813_c = false;
            entity.field_145812_b = 1;
            this.field_70170_p.func_217376_c((Entity)entity);
            if (++size <= 50) continue;
            break;
        }
    }
}

