/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.hie;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.FoliageBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.LiquidBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.HieProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModEffects;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class IceBallProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(AirBlockProtectionRule.INSTANCE, LiquidBlockProtectionRule.INSTANCE, FoliageBlockProtectionRule.INSTANCE);

    public IceBallProjectile(World world) {
        super(HieProjectiles.ICE_BALL, world);
    }

    public IceBallProjectile(EntityType type, World world) {
        super(type, world);
    }

    public IceBallProjectile(World world, double x, double y, double z) {
        super(HieProjectiles.ICE_BALL, world, x, y, z);
    }

    public IceBallProjectile(World world, LivingEntity player) {
        super(HieProjectiles.ICE_BALL, world, player);
        this.setDamage(25.0f);
        this.setMaxLife(32);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
        this.withEffects = () -> new EffectInstance[]{new EffectInstance(ModEffects.FROZEN, 200, 0), new EffectInstance(Effects.field_76421_d, 100, 0), new EffectInstance(Effects.field_76419_f, 100, 0)};
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.createEmptySphere(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o(), hit.func_177952_p(), 6, Blocks.field_205164_gk, GRIEF_RULE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 10; ++i) {
                double offsetX = WyHelper.randomDouble() / 1.5;
                double offsetY = WyHelper.randomDouble() / 1.5;
                double offsetZ = WyHelper.randomDouble() / 1.5;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.HIE);
                data.setLife(3);
                data.setSize(1.5f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

