/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.magu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.BlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.CoreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.api.protection.block.OreBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.magu.MaguProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModDamageSource;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class MeigoProjectile
extends AbilityProjectileEntity {
    private static final BlockProtectionRule GRIEF_RULE = new BlockProtectionRule(CoreBlockProtectionRule.INSTANCE, AirBlockProtectionRule.INSTANCE, OreBlockProtectionRule.INSTANCE);

    public MeigoProjectile(World world) {
        super(MaguProjectiles.MEIGO, world);
    }

    public MeigoProjectile(EntityType type, World world) {
        super(type, world);
    }

    public MeigoProjectile(World world, double x, double y, double z) {
        super(MaguProjectiles.MEIGO, world, x, y, z);
    }

    public MeigoProjectile(World world, LivingEntity player) {
        super(MaguProjectiles.MEIGO, world, player);
        this.setDamage(100.0f);
        this.setMaxLife(4);
        this.setPassThroughEntities();
        this.setCanGetStuckInGround();
        this.setAffectedByHardening();
        this.setDamageSource(ModDamageSource.MAGMA.causeIndirectDamageFromSource(this));
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        SetOnFireEvent event = new SetOnFireEvent(this.func_85052_h(), hitEntity, 20);
        if (!MinecraftForge.EVENT_BUS.post((Event)event)) {
            hitEntity.func_70015_d(20);
        }
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.createFilledSphere(this.func_130014_f_(), (int)this.func_226277_ct_(), (int)this.func_226278_cu_(), (int)this.func_226281_cx_(), 2, Blocks.field_150353_l, GRIEF_RULE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            double offsetZ;
            double offsetY;
            double offsetX;
            int i;
            for (i = 0; i < 3; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                GenericParticleData data = new GenericParticleData(ModParticleTypes.MERA);
                data.setLife(5);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
            for (i = 0; i < 10; ++i) {
                offsetX = WyHelper.randomDouble() / 2.0;
                offsetY = WyHelper.randomDouble() / 2.0;
                offsetZ = WyHelper.randomDouble() / 2.0;
                ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197595_F, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ, 1, 0.0, 0.0, 0.0, 0.5);
            }
        }
    }
}

