/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.netsu;

import net.minecraft.block.Blocks;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.ParticleType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.abilities.netsu.NetsuEnhancementAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.protection.block.AirBlockProtectionRule;
import xyz.pixelatedw.mineminenomi.entities.projectiles.netsu.NetsuProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class NekkaiGyoraiProjectile
extends AbilityProjectileEntity {
    private int damage = 10;

    public NekkaiGyoraiProjectile(World world) {
        super(NetsuProjectiles.NEKKAI_GYORAI, world);
    }

    public NekkaiGyoraiProjectile(World world, LivingEntity player) {
        super(NetsuProjectiles.NEKKAI_GYORAI, world, player);
        IAbilityData abilityProps = AbilityDataCapability.get(player);
        NetsuEnhancementAbility ability = abilityProps.getEquippedAbility(NetsuEnhancementAbility.INSTANCE);
        if (ability != null && ability.isContinuous()) {
            this.damage += 5;
        }
        this.setDamage(this.damage);
        this.setDamageSource(DamageSource.field_76372_a);
        this.setMaxLife(30);
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onBlockImpactEvent = this::onBlockImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity hitEntity) {
        hitEntity.func_70015_d(4);
    }

    private void onBlockImpactEvent(BlockPos hit) {
        AbilityHelper.placeBlockIfAllowed(this.field_70170_p, hit.func_177958_n(), hit.func_177956_o() + 1, hit.func_177952_p(), Blocks.field_150480_ab, AirBlockProtectionRule.INSTANCE);
    }

    private void onTickEvent() {
        if (!this.field_70170_p.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double offsetX = WyHelper.randomDouble() / 2.0;
                double offsetY = WyHelper.randomDouble() / 2.0;
                double offsetZ = WyHelper.randomDouble() / 2.0;
                ParticleType<GenericParticleData> particle = ModParticleTypes.NETSU;
                if (i % 3 == 0) {
                    particle = ModParticleTypes.NETSU2;
                }
                if (i % 7 == 0) {
                    particle = ModParticleTypes.MERA;
                }
                GenericParticleData data = new GenericParticleData(particle);
                data.setLife(10);
                data.setSize(1.3f);
                WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            }
        }
    }
}

