/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.entities.projectiles.toriphoenix;

import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.entities.projectiles.toriphoenix.ToriPhoenixProjectiles;
import xyz.pixelatedw.mineminenomi.init.ModParticleTypes;
import xyz.pixelatedw.mineminenomi.particles.data.GenericParticleData;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;

public class PhoenixGoenProjectile
extends AbilityProjectileEntity {
    Vec3d lookVec;

    public PhoenixGoenProjectile(World world) {
        super(ToriPhoenixProjectiles.PHOENIX_GOEN, world);
    }

    public PhoenixGoenProjectile(EntityType type, World world) {
        super(type, world);
    }

    public PhoenixGoenProjectile(World world, double x, double y, double z) {
        super(ToriPhoenixProjectiles.PHOENIX_GOEN, world, x, y, z);
    }

    public PhoenixGoenProjectile(World world, LivingEntity player, Vec3d lookVec) {
        super(ToriPhoenixProjectiles.PHOENIX_GOEN, world, player);
        this.setDamage(3.0f);
        this.setCanGetStuckInGround();
        this.setMaxLife(10);
        this.setChangeHurtTime(true);
        this.setPhysical(false);
        this.setAffectedByImbuing();
        this.lookVec = lookVec;
        this.onEntityImpactEvent = this::onEntityImpactEvent;
        this.onTickEvent = this::onTickEvent;
    }

    private void onEntityImpactEvent(LivingEntity target) {
        Vec3d speed = this.lookVec.func_216372_d(2.0, 0.0, 2.0);
        target.func_213293_j(speed.field_72450_a, 0.75, speed.field_72449_c);
        target.field_70133_I = true;
        target.field_70143_R = 0.0f;
    }

    private void onTickEvent() {
        float mult = (float)this.getLife() / ((float)this.getMaxLife() * 1.25f);
        int i = 0;
        while ((float)i < 25.0f * mult) {
            double offsetX = WyHelper.randomDouble() * (double)mult;
            double offsetY = WyHelper.randomDouble() * (double)mult;
            double offsetZ = WyHelper.randomDouble() * (double)mult;
            GenericParticleData data = new GenericParticleData(ModParticleTypes.BLUE_FLAME);
            data.setLife(8);
            data.setSize(3.0f * mult);
            WyHelper.spawnParticles(data, (ServerWorld)this.field_70170_p, this.func_226277_ct_() + offsetX, this.func_226278_cu_() + offsetY, this.func_226281_cx_() + offsetZ);
            ++i;
        }
    }
}

