/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import com.mojang.authlib.GameProfile;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.IItemProvider;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.helpers.BountyHelper;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.WantedPosterTileEntity;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.WantedPosterPackageEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncEntityStatsPacket;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncWorldDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class BountyEvents {
    private static HashMap<PlayerEntity, double[]> cachedPositions = new HashMap();

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.WorldTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side != LogicalSide.SERVER || !CommonConfig.INSTANCE.isWantedPosterPackagesEnabled()) {
            return;
        }
        if (event.world.func_72820_D() % (long)CommonConfig.INSTANCE.getTimeBetweenPackages() != 0L) {
            return;
        }
        ServerPlayerEntity player = ((ServerWorld)event.world).func_217472_l_();
        if (player != null) {
            double currentPosX = player.func_226277_ct_();
            double currentPosZ = player.func_226281_cx_();
            if (!cachedPositions.containsKey(player)) {
                cachedPositions.put((PlayerEntity)player, new double[]{currentPosX, currentPosZ});
            } else {
                boolean flagPosZ;
                double[] positions = cachedPositions.get(player);
                double cachedPosX = positions[0];
                double cachedPosZ = positions[1];
                boolean flagPosX = Math.abs(currentPosX - cachedPosX) > 100.0;
                boolean bl = flagPosZ = Math.abs(currentPosZ - cachedPosZ) > 100.0;
                if (flagPosX || flagPosZ) {
                    if (BountyHelper.issueBountyForPlayer((PlayerEntity)player)) {
                        WantedPosterPackageEntity pkg = new WantedPosterPackageEntity(player.field_70170_p);
                        pkg.func_70012_b(player.func_226277_ct_() + WyHelper.randomWithRange(-10, 10), player.func_226278_cu_() + 30.0, player.func_226281_cx_() + WyHelper.randomWithRange(-10, 10), 0.0f, 0.0f);
                        player.field_70170_p.func_217376_c((Entity)pkg);
                    }
                    cachedPositions.remove(player);
                    cachedPositions.put((PlayerEntity)player, new double[]{currentPosX, currentPosZ});
                }
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState().func_177230_c() == ModBlocks.WANTED_POSTER) {
            ItemStack stack = new ItemStack((IItemProvider)ModBlocks.WANTED_POSTER.func_199767_j());
            WantedPosterTileEntity tileEntity = (WantedPosterTileEntity)event.getWorld().func_175625_s(event.getPos());
            CompoundNBT nbt = stack.func_196082_o();
            nbt.func_74778_a("UUID", tileEntity.getUUID());
            nbt.func_74778_a("Name", tileEntity.getEntityName());
            long bounty = 0L;
            try {
                bounty = Long.parseLong(tileEntity.getPosterBounty());
            }
            catch (NumberFormatException ex) {
                ex.printStackTrace();
            }
            nbt.func_74772_a("Bounty", bounty);
            nbt.func_74778_a("Background", tileEntity.getBackground());
            nbt.func_74778_a("Faction", tileEntity.getFaction());
            nbt.func_74778_a("Date", tileEntity.getIssuedDate());
            CompoundNBT compoundnbt = new CompoundNBT();
            NBTUtil.func_180708_a((CompoundNBT)compoundnbt, (GameProfile)event.getPlayer().func_146103_bH());
            nbt.func_218657_a("Owner", (INBT)compoundnbt);
            event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), stack));
        }
    }

    @SubscribeEvent
    public static void onBountyKilled(LivingDeathEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity && !event.getEntityLiving().field_70170_p.field_72995_K) {
            if (!EntityStatsCapability.get((LivingEntity)event.getSource().func_76346_g()).isBountyHunter()) {
                return;
            }
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
            IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
            IEntityStats targetProps = EntityStatsCapability.get(target);
            WyNetwork.sendTo(new SSyncEntityStatsPacket(target.func_145782_y(), targetProps), player);
            for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
                boolean hasBounty;
                ItemStack itemStack = player.field_71071_by.func_70301_a(i);
                if (!itemStack.func_77942_o()) continue;
                String uuid = itemStack.func_77978_p().func_74779_i("UUID");
                Long bounty = itemStack.func_77978_p().func_74763_f("Bounty");
                if (WyHelper.isNullOrEmpty(uuid)) continue;
                boolean isTarget = UUID.fromString(uuid).equals(target.func_110124_au());
                boolean bl = hasBounty = worldData.getBounty(target.func_110124_au().toString()) == bounty.longValue();
                if (!isTarget || !hasBounty) continue;
                worldData.issueBounty(uuid, 0L);
                long bellyGain = 0L;
                if (CommonConfig.INSTANCE.getAfterDeathLogic() == CommonConfig.KeepStatsLogic.AUTO) {
                    bellyGain = targetProps.getBounty() / 3L;
                } else if (CommonConfig.INSTANCE.getAfterDeathLogic() == CommonConfig.KeepStatsLogic.NONE) {
                    bellyGain = targetProps.getBounty();
                }
                props.alterBelly(bellyGain);
                WyNetwork.sendTo(new SSyncEntityStatsPacket(player.func_145782_y(), props), player);
                WyNetwork.sendToAll(new SSyncWorldDataPacket(worldData));
            }
        }
    }
}

