/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.SetPlayerDetailsEvent;
import xyz.pixelatedw.mineminenomi.api.helpers.FightingStyleHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class FightingStylesEvents {
    @SubscribeEvent
    public static void onStatsChoose(SetPlayerDetailsEvent event) {
        if (event.getEntityStats().isBlackLeg()) {
            FightingStyleHelper.applyBlackLegModifiers(event.getPlayer());
        }
        if (event.getEntityStats().isBrawler()) {
            FightingStyleHelper.applyBrawlerModifiers(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void edgeCasesChecks(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START || event.side != LogicalSide.SERVER || event.player.field_70173_aa % 5 != 0) {
            return;
        }
        PlayerEntity player = event.player;
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        boolean isHandEmpty = player.func_184614_ca().func_190926_b();
        if (props.isBlackLeg()) {
            if (!isHandEmpty && FightingStyleHelper.hasBlackLegModifiers(player)) {
                FightingStyleHelper.removeBlackLegModifiers(player);
            } else if (isHandEmpty && !FightingStyleHelper.hasBlackLegModifiers(player)) {
                FightingStyleHelper.applyBlackLegModifiers(player);
            }
        } else if (props.isBrawler()) {
            if (!isHandEmpty && FightingStyleHelper.hasBrawlerModifiers(player)) {
                FightingStyleHelper.removeBrawlerModifiers(player);
            } else if (isHandEmpty && !FightingStyleHelper.hasBrawlerModifiers(player)) {
                FightingStyleHelper.applyBrawlerModifiers(player);
            }
        } else {
            if (FightingStyleHelper.hasBrawlerModifiers(player)) {
                FightingStyleHelper.removeBrawlerModifiers(player);
            }
            if (FightingStyleHelper.hasBlackLegModifiers(player)) {
                FightingStyleHelper.removeBlackLegModifiers(player);
            }
        }
    }
}

