/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.util.Hand;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.brewing.PlayerBrewedPotionEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.api.events.DorikiEvent;
import xyz.pixelatedw.mineminenomi.api.events.LivingHealByEvent;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IBrewPotionObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.ICureEffectObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IEntityInteractObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IEquipItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IHealEntityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IHitEntityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IKillEntityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IObtainItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IReachDorikiObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.ISurviveObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IUseAbilityObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.IUseItemObjective;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.data.entity.quests.IQuestData;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncQuestDataPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.AbilityUseEvent;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class QuestEvents {
    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        IQuestData questProps = QuestDataCapability.get(player);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), (PlayerEntity)((ServerPlayerEntity)player));
    }

    @SubscribeEvent
    public static void onPotionRemoved(LivingEntityUseItemEvent.Stop event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IUseItemObjective) || !((IUseItemObjective)((Object)obj)).checkItem(player, event.getItem(), event.getDuration())) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent
    public static void onPlayerAbilityUse(AbilityUseEvent event) {
        if (!event.getPlayer().field_70170_p.field_72995_K) {
            PlayerEntity player = event.getPlayer();
            IQuestData questProps = QuestDataCapability.get(player);
            for (Objective obj : questProps.getInProgressObjectives()) {
                if (!(obj instanceof IUseAbilityObjective) || !((IUseAbilityObjective)((Object)obj)).checkAbility(player, event.getAbility())) continue;
                obj.alterProgress(1.0);
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerBrews(PlayerBrewedPotionEvent event) {
        if (event.getPlayer().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IBrewPotionObjective) || !((IBrewPotionObjective)((Object)obj)).checkPotion(player, event.getStack())) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side == LogicalSide.SERVER && event.player.field_70173_aa % 20 == 0) {
            PlayerEntity player = event.player;
            IQuestData questProps = QuestDataCapability.get(player);
            for (Objective obj : questProps.getInProgressObjectives()) {
                if (obj instanceof IEquipItemObjective && ((IEquipItemObjective)((Object)obj)).checkEquippedItem(player)) {
                    obj.alterProgress(1.0);
                    WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
                }
                if (!(obj instanceof ISurviveObjective) || !((ISurviveObjective)((Object)obj)).checkTime(player)) continue;
                obj.alterProgress(1.0);
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityDies(LivingDeathEvent event) {
        if (!(event.getSource().func_76346_g() instanceof PlayerEntity) || event.getSource().func_76346_g().field_70170_p.field_72995_K) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
        LivingEntity target = event.getEntityLiving();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IKillEntityObjective) || !((IKillEntityObjective)((Object)obj)).checkKill(player, target, event.getSource())) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityAttack(LivingHurtEvent event) {
        if (event.getSource().func_76346_g() instanceof PlayerEntity && !event.getSource().func_76346_g().field_70170_p.field_72995_K && event.getEntityLiving() instanceof LivingEntity) {
            PlayerEntity player = (PlayerEntity)event.getSource().func_76346_g();
            LivingEntity target = event.getEntityLiving();
            IQuestData questProps = QuestDataCapability.get(player);
            for (Objective obj : questProps.getInProgressObjectives()) {
                if (!(obj instanceof IHitEntityObjective) || !((IHitEntityObjective)((Object)obj)).checkHit(player, target, event.getSource(), event.getAmount())) continue;
                obj.alterProgress(1.0);
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onEntityHealed(LivingHealByEvent event) {
        if (event.getHealer() instanceof PlayerEntity && !event.getHealer().field_70170_p.field_72995_K && event.getEntityLiving() instanceof LivingEntity) {
            PlayerEntity player = (PlayerEntity)event.getHealer();
            LivingEntity target = event.getEntityLiving();
            IQuestData questProps = QuestDataCapability.get(player);
            for (Objective obj : questProps.getInProgressObjectives()) {
                if (!(obj instanceof IHealEntityObjective) || !((IHealEntityObjective)((Object)obj)).checkHeal(player, target, event.getAmount())) continue;
                obj.alterProgress(1.0);
                WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickedUp(EntityItemPickupEvent event) {
        PlayerEntity player = event.getPlayer();
        IQuestData questProps = QuestDataCapability.get(player);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IObtainItemObjective) || !((IObtainItemObjective)((Object)obj)).checkItem(event.getItem().func_92059_d())) continue;
            obj.alterProgress(event.getItem().func_92059_d().func_190916_E());
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent
    public static void onItemTossed(ItemTossEvent event) {
        PlayerEntity player = event.getPlayer();
        IQuestData questProps = QuestDataCapability.get(player);
        if (player.field_70170_p.field_72995_K) {
            return;
        }
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IObtainItemObjective) || !((IObtainItemObjective)((Object)obj)).checkItem(event.getEntityItem().func_92059_d()) || !(obj.getProgress() > 0.0)) continue;
            obj.alterProgress(-event.getEntityItem().func_92059_d().func_190916_E());
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent
    public static void onEntityInteract(PlayerInteractEvent.EntityInteractSpecific event) {
        if (event.getHand() != Hand.MAIN_HAND) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IEntityInteractObjective) || !((IEntityInteractObjective)((Object)obj)).checkInteraction(player, event.getTarget())) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
            return;
        }
    }

    @SubscribeEvent
    public static void onDorikiGained(DorikiEvent event) {
        if (!(event.getEntity() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntity();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof IReachDorikiObjective) || !((IReachDorikiObjective)((Object)obj)).checkDoriki(player)) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }

    @SubscribeEvent
    public static void onPotionRemoved(PotionEvent.PotionRemoveEvent event) {
        if (!(event.getEntityLiving() instanceof PlayerEntity)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)event.getEntityLiving();
        IQuestData questProps = QuestDataCapability.get(player);
        for (Objective obj : questProps.getInProgressObjectives()) {
            if (!(obj instanceof ICureEffectObjective) || !((ICureEffectObjective)((Object)obj)).checkEffect(player, event.getPotionEffect())) continue;
            obj.alterProgress(1.0);
            WyNetwork.sendTo(new SSyncQuestDataPacket(player.func_145782_y(), questProps), player);
        }
    }
}

