/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.events.devilfruits;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.LeavesBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.screen.inventory.CreativeScreen;
import net.minecraft.client.gui.screen.inventory.InventoryScreen;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.item.ItemFrameEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.inventory.container.ShulkerBoxContainer;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.item.ItemExpireEvent;
import net.minecraftforge.event.entity.item.ItemTossEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerContainerEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.DevilFruitHelper;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;
import xyz.pixelatedw.mineminenomi.entities.zoan.YomiZoanInfo;
import xyz.pixelatedw.mineminenomi.init.ModAbilities;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModValues;
import xyz.pixelatedw.mineminenomi.items.AkumaNoMiItem;
import xyz.pixelatedw.mineminenomi.packets.server.SSyncDevilFruitPacket;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi")
public class OneFruitPerWorldEvents {
    private static final com.mojang.datafixers.util.Pair<ResourceLocation, ResourceLocation> OFFHAND_TEXTURE = com.mojang.datafixers.util.Pair.of((Object)PlayerContainer.field_226615_c_, (Object)PlayerContainer.field_226620_h_);

    @SubscribeEvent
    public static void onBreak(BlockEvent.BreakEvent event) {
        double chance;
        boolean hasShears;
        boolean bl = hasShears = event.getPlayer().func_184586_b(event.getPlayer().func_184600_cs()).func_77973_b() == Items.field_151097_aZ;
        if (CommonConfig.INSTANCE.getDevilFruitDropsFromLeavesChance() > 0.0 && event.getState().func_177230_c() instanceof LeavesBlock && !hasShears && (chance = WyHelper.randomWithRange(0, 100) + WyHelper.randomDouble()) < CommonConfig.INSTANCE.getDevilFruitDropsFromLeavesChance()) {
            AkumaNoMiItem df = ModValues.devilfruits.get((int)WyHelper.randomWithRange(0, ModValues.devilfruits.size() - 1));
            df = DevilFruitHelper.oneFruitPerWorldCheck((World)event.getWorld(), df);
            if (df != null) {
                event.getWorld().func_217376_c((Entity)new ItemEntity((World)event.getWorld(), (double)event.getPos().func_177958_n(), (double)event.getPos().func_177956_o(), (double)event.getPos().func_177952_p(), new ItemStack((IItemProvider)df)));
                ExtendedWorldData.get(event.getPlayer().field_70170_p).addDevilFruitInWorld(df);
            }
        }
    }

    @SubscribeEvent
    public static void onExpire(ItemExpireEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic() && event.getEntityItem().func_92059_d().func_77973_b() instanceof AkumaNoMiItem) {
            ItemStack itemStack = event.getEntityItem().func_92059_d();
            AkumaNoMiItem item = (AkumaNoMiItem)itemStack.func_77973_b();
            ExtendedWorldData worldData = ExtendedWorldData.get(event.getEntityItem().field_70170_p);
            worldData.removeDevilFruitInWorld(item);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void mouseClickEvent(GuiScreenEvent.MouseClickedEvent.Pre event) {
        Slot slotUnderMouse;
        if (Minecraft.func_71410_x().field_71439_g == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return;
        }
        if (event.getGui() instanceof ContainerScreen && (slotUnderMouse = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slotUnderMouse.func_225517_c_() != null && slotUnderMouse.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
            return;
        }
        ItemStack cap = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (!(cap.func_77973_b() instanceof AkumaNoMiItem) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen)) {
            event.setCanceled(true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void mouseReleaseEvent(GuiScreenEvent.MouseReleasedEvent.Pre event) {
        Slot slotUnderMouse;
        if (Minecraft.func_71410_x().field_71439_g == null || !CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            return;
        }
        if (event.getGui() instanceof ContainerScreen && (slotUnderMouse = ((ContainerScreen)event.getGui()).getSlotUnderMouse()) != null && slotUnderMouse.func_225517_c_() != null && slotUnderMouse.func_225517_c_().equals(OFFHAND_TEXTURE)) {
            event.setCanceled(true);
            return;
        }
        ItemStack cap = Minecraft.func_71410_x().field_71439_g.field_71071_by.func_70445_o();
        if (!(cap.func_77973_b() instanceof AkumaNoMiItem) || event.getGui() instanceof CreativeScreen) {
            return;
        }
        if (!(event.getGui() instanceof InventoryScreen)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onContainerOpen(PlayerContainerEvent.Open event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic() && event.getContainer() instanceof ShulkerBoxContainer) {
            PlayerEntity player = event.getPlayer();
            for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
                ItemStack stack = (ItemStack)player.field_71071_by.field_70462_a.get(i);
                if (stack == null || !(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                event.getPlayer().func_71019_a(stack.func_77946_l(), false);
                stack.func_190918_g(stack.func_190916_E());
            }
            OneFruitPerWorldEvents.dropFruitsFromNearbyContainers(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onContainerClose(PlayerContainerEvent.Close event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic() && !(event.getContainer() instanceof PlayerContainer)) {
            int containerSlots = event.getContainer().field_75151_b.size() - event.getPlayer().field_71071_by.field_70462_a.size();
            for (int i = 0; i < containerSlots; ++i) {
                Slot slot = (Slot)event.getContainer().field_75151_b.get(i);
                if (!slot.func_75216_d() || !(slot.func_75211_c().func_77973_b() instanceof AkumaNoMiItem)) continue;
                event.getPlayer().func_71019_a(slot.func_75211_c().func_77946_l(), false);
                slot.func_75209_a(1);
            }
            OneFruitPerWorldEvents.dropFruitsFromNearbyContainers(event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onRightClick(PlayerInteractEvent.EntityInteract event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic() && event.getTarget() instanceof ItemFrameEntity && !event.getItemStack().func_190926_b() && event.getItemStack().func_77973_b() instanceof AkumaNoMiItem) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerDeath(LivingDeathEvent event) {
        if (event.getEntityLiving() instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            IDevilFruit fruitProps = DevilFruitCapability.get((LivingEntity)player);
            ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
                if (!fruitProps.hasDevilFruit(ModAbilities.YOMI_YOMI_NO_MI) || YomiZoanInfo.INSTANCE.isActive((LivingEntity)player)) {
                    worldData.removeAteDevilFruit(player);
                    worldData.removeDevilFruitInWorld(fruitProps.getDevilFruit());
                }
                if (fruitProps.hasYamiPower()) {
                    String yamiString = DevilFruitHelper.getDevilFruitKey(ModAbilities.YAMI_YAMI_NO_MI);
                    worldData.removeDevilFruitInWorld(yamiString);
                }
                ArrayList slots = new ArrayList();
                slots.addAll(player.field_71071_by.field_70462_a);
                slots.addAll(player.field_71071_by.field_184439_c);
                for (ItemStack invStack : slots) {
                    if (invStack == null || !(invStack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                    worldData.removeDevilFruitInInventory(player.func_110124_au(), DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)invStack.func_77973_b()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof PlayerEntity && !event.getWorld().field_72995_K && CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            PlayerEntity player = (PlayerEntity)event.getEntity();
            ExtendedWorldData worldProps = ExtendedWorldData.get(player.field_70170_p);
            if (worldProps != null) {
                OneFruitPerWorldEvents.checkForCachedInactivity(player.field_70170_p, worldProps);
                boolean playerCheck = OneFruitPerWorldEvents.checkForInactivityAtLogin(player, worldProps);
                if (playerCheck) {
                    worldProps.removeLoggedOutFruit(player.func_110124_au());
                    player.func_145747_a((ITextComponent)new TranslationTextComponent(ModI18n.SYSTEM_MESSAGE_OFPW_INACTIVITY, new Object[0]));
                }
            }
            if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
                OneFruitPerWorldEvents.dropFruitsFromNearbyContainers((PlayerEntity)event.getEntity());
                boolean isDFUser = DevilFruitCapability.get((LivingEntity)player).hasDevilFruit();
                int fruitsFound = 0;
                ArrayList slots = new ArrayList();
                slots.addAll(player.field_71071_by.field_70462_a);
                slots.addAll(player.field_71071_by.field_184439_c);
                for (ItemStack invStack : slots) {
                    if (invStack.func_190926_b() || !(invStack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                    String fruitKey = DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)invStack.func_77973_b());
                    if (isDFUser && CommonConfig.INSTANCE.getUnableToPickDFAsUser()) {
                        worldProps.removeDevilFruitInInventory(player.func_110124_au(), fruitKey);
                        worldProps.removeDevilFruitInWorld(fruitKey);
                        invStack.func_190918_g(1);
                    }
                    for (String fruit : worldProps.getAteFruits().values()) {
                        if (!fruit.equalsIgnoreCase(fruitKey)) continue;
                        System.out.println(player.func_145748_c_().func_150254_d() + " had an already in use fruit, " + fruitKey + ", which was removed from their inventory!");
                        invStack.func_190918_g(1);
                    }
                    if (invStack.func_190916_E() <= 0 || ++fruitsFound <= CommonConfig.INSTANCE.getInventoryLimitForFruits()) continue;
                    worldProps.removeDevilFruitInInventory(player.func_110124_au(), fruitKey);
                    worldProps.removeDevilFruitInWorld(fruitKey);
                    invStack.func_190918_g(1);
                }
            }
            for (ItemStack invStack : player.field_71071_by.field_70462_a) {
                if (invStack == null || !(invStack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                worldProps.addDevilFruitInInventory(player.func_110124_au(), DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)invStack.func_77973_b()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeavesWorld(PlayerEvent.PlayerLoggedOutEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            PlayerEntity player = event.getPlayer();
            IDevilFruit dfProps = DevilFruitCapability.get((LivingEntity)player);
            ExtendedWorldData worldData = ExtendedWorldData.get(player.field_70170_p);
            ArrayList<String> fruits = new ArrayList<String>();
            if (dfProps.hasDevilFruit()) {
                fruits.add(dfProps.getDevilFruit());
            }
            if (dfProps.hasYamiPower()) {
                String yamiString = DevilFruitHelper.getDevilFruitKey(ModAbilities.YAMI_YAMI_NO_MI);
                fruits.add(yamiString);
            }
            PlayerInventory inv = player.field_71071_by;
            for (ItemStack stack : inv.field_70462_a) {
                if (!(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                String key = DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)stack.func_77973_b());
                fruits.add(key);
            }
            if (!fruits.isEmpty()) {
                worldData.addLoggedOutFruit(player.func_110124_au(), fruits);
            }
        }
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            OneFruitPerWorldEvents.dropFruitsFromNearbyContainers((PlayerEntity)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onItemPickedUp(EntityItemPickupEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldExtendedLogic()) {
            PlayerEntity player = event.getPlayer();
            ItemStack stack = event.getItem().func_92059_d();
            if (stack.func_77973_b() == Items.field_221970_gq && stack.func_77942_o()) {
                ListNBT items = stack.func_196082_o().func_74775_l("BlockEntityTag").func_150295_c("Items", 10);
                for (int i = 0; i < items.size(); ++i) {
                    CompoundNBT itemNBT = items.func_150305_b(i);
                    String itemId = itemNBT.func_74779_i("id");
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(itemId));
                    if (item == null || !(item instanceof AkumaNoMiItem)) continue;
                    items.remove(i);
                }
            } else if (stack.func_77973_b() instanceof AkumaNoMiItem) {
                if (DevilFruitCapability.get((LivingEntity)player).hasDevilFruit() && CommonConfig.INSTANCE.getUnableToPickDFAsUser()) {
                    event.setCanceled(true);
                    return;
                }
                if (DevilFruitHelper.hasDFLimitInInventory(player)) {
                    event.setCanceled(true);
                } else {
                    ExtendedWorldData worldProps = ExtendedWorldData.get(player.field_70170_p);
                    worldProps.addDevilFruitInInventory(player.func_110124_au(), DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)stack.func_77973_b()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onDevilFruitDropped(ItemTossEvent event) {
        if (CommonConfig.INSTANCE.hasOneFruitPerWorldSimpleLogic()) {
            PlayerEntity player = event.getPlayer();
            ItemStack stack = event.getEntityItem().func_92059_d();
            ExtendedWorldData worldProps = ExtendedWorldData.get(player.field_70170_p);
            if (stack.func_77973_b() instanceof AkumaNoMiItem) {
                worldProps.removeDevilFruitInInventory(player.func_110124_au(), DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)stack.func_77973_b()));
            }
        }
    }

    private static void dropFruitsFromNearbyContainers(PlayerEntity player) {
        List<BlockPos> blockPosList = WyHelper.getNearbyTileEntities((LivingEntity)player, 40);
        for (BlockPos pos : blockPosList) {
            TileEntity te = player.field_70170_p.func_175625_s(pos);
            if (!(te instanceof IInventory)) continue;
            for (int i = 0; i < ((IInventory)te).func_70302_i_(); ++i) {
                ItemStack stack = ((IInventory)te).func_70301_a(i);
                if (stack == null || !(stack.func_77973_b() instanceof AkumaNoMiItem)) continue;
                player.func_71019_a(stack.func_77946_l(), false);
                stack.func_190918_g(stack.func_190916_E());
            }
        }
    }

    private static boolean checkForCachedInactivity(World world, ExtendedWorldData worldProps) {
        for (Map.Entry<UUID, Pair<Date, List<String>>> entry : worldProps.getLoggedOutDevilFruits().entrySet()) {
            Date date;
            long diff;
            UUID playerUUID = entry.getKey();
            Pair<Date, List<String>> pair = entry.getValue();
            if (pair == null || (diff = WyHelper.getDaysSince(date = (Date)pair.getKey())) < (long)CommonConfig.INSTANCE.getDaysForInactivity()) continue;
            boolean flag = false;
            ArrayList fruits = new ArrayList((Collection)pair.getValue());
            if (!fruits.isEmpty()) {
                for (Map.Entry<UUID, String> entry2 : worldProps.getAteFruits().entrySet()) {
                    if (!entry2.getKey().equals(playerUUID)) continue;
                    worldProps.removeDevilFruitInWorld(entry2.getValue());
                    worldProps.removeAteDevilFruit(playerUUID);
                    fruits.remove(entry2.getValue());
                    flag = true;
                    break;
                }
                for (Map.Entry<UUID, Object> entry3 : worldProps.getFruitsInInventory().entrySet()) {
                    if (!entry3.getKey().equals(entry.getKey())) continue;
                    worldProps.removeDevilFruitsInWorld((List)entry3.getValue());
                    worldProps.removeDevilFruitsInInventory(entry.getKey(), (List)entry3.getValue());
                    fruits.removeAll((Collection)entry3.getValue());
                    flag = true;
                    break;
                }
            }
            return flag;
        }
        return false;
    }

    private static boolean checkForInactivityAtLogin(PlayerEntity player, ExtendedWorldData worldProps) {
        Pair<Date, List<String>> pair = worldProps.getLoggedOutPlayer(player.func_110124_au());
        if (pair != null) {
            Date date = (Date)pair.getKey();
            long diff = WyHelper.getDaysSince(date);
            if (diff >= (long)CommonConfig.INSTANCE.getDaysForInactivity()) {
                boolean flag = false;
                ArrayList fruits = new ArrayList((Collection)pair.getValue());
                if (!fruits.isEmpty()) {
                    IDevilFruit dfProps = DevilFruitCapability.get((LivingEntity)player);
                    IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)player);
                    String yamiString = DevilFruitHelper.getDevilFruitKey(ModAbilities.YAMI_YAMI_NO_MI);
                    String dfKey = dfProps.getDevilFruit();
                    if (fruits.contains(dfKey)) {
                        dfProps.setDevilFruit("");
                        dfProps.setZoanPoint("");
                        abilityProps.clearUnlockedAbilities(AbilityHelper.getDevilFruitCategory());
                        abilityProps.clearEquippedAbilities(AbilityHelper.getDevilFruitCategory());
                        WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), dfProps), player);
                        fruits.remove(dfKey);
                        flag = true;
                    }
                    if (fruits.contains(yamiString)) {
                        dfProps.setYamiPower(false);
                        abilityProps.clearUnlockedAbilities(AbilityHelper.getDevilFruitCategory());
                        abilityProps.clearEquippedAbilities(AbilityHelper.getDevilFruitCategory());
                        WyNetwork.sendTo(new SSyncDevilFruitPacket(player.func_145782_y(), dfProps), player);
                        fruits.remove(yamiString);
                        flag = true;
                    }
                    ArrayList slots = new ArrayList();
                    slots.addAll(player.field_71071_by.field_70462_a);
                    slots.addAll(player.field_71071_by.field_184439_c);
                    for (ItemStack stack : slots) {
                        String key;
                        if (stack == null || !(stack.func_77973_b() instanceof AkumaNoMiItem) || !fruits.contains(key = DevilFruitHelper.getDevilFruitKey((AkumaNoMiItem)stack.func_77973_b()))) continue;
                        stack.func_190918_g(1);
                        fruits.remove(key);
                        flag = true;
                    }
                }
                return flag;
            }
            worldProps.removeLoggedOutFruit(player.func_110124_au());
            return false;
        }
        return false;
    }
}

