/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.init;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.settings.KeyBinding;
import net.minecraft.client.util.InputMappings;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CChangeCombatBarPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CToggleCombatModePacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CUseAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ui.COpenPlayerScreenPacket;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@Mod.EventBusSubscriber(modid="mineminenomi", value={Dist.CLIENT})
public class ModKeybindings {
    public static KeyBinding guiPlayer;
    public static KeyBinding enterCombatMode;
    public static KeyBinding nextCombatBar;
    public static KeyBinding prevCombatBar;
    public static KeyBinding combatSlot1;
    public static KeyBinding combatSlot2;
    public static KeyBinding combatSlot3;
    public static KeyBinding combatSlot4;
    public static KeyBinding combatSlot5;
    public static KeyBinding combatSlot6;
    public static KeyBinding combatSlot7;
    public static KeyBinding combatSlot8;
    private static KeyBinding[] keyBindsCombatbar;
    private static final int[] PREVIOUS_INVENTORY_KEYBINDS;
    private static int[] keyCooldown;

    public static void init() {
        guiPlayer = new KeyBinding(ModI18n.KEY_PLAYER, 82, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)guiPlayer);
        enterCombatMode = new KeyBinding(ModI18n.KEY_COMBATMODE, 342, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)enterCombatMode);
        nextCombatBar = new KeyBinding(ModI18n.KEY_NEXT_COMBAT_BAR, 93, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)nextCombatBar);
        prevCombatBar = new KeyBinding(ModI18n.KEY_PREV_COMBAT_BAR, 91, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)prevCombatBar);
        combatSlot1 = new KeyBinding(ModI18n.KEY_COMBATSLOT1, 49, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot1);
        combatSlot2 = new KeyBinding(ModI18n.KEY_COMBATSLOT2, 50, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot2);
        combatSlot3 = new KeyBinding(ModI18n.KEY_COMBATSLOT3, 51, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot3);
        combatSlot4 = new KeyBinding(ModI18n.KEY_COMBATSLOT4, 52, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot4);
        combatSlot5 = new KeyBinding(ModI18n.KEY_COMBATSLOT5, 53, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot5);
        combatSlot6 = new KeyBinding(ModI18n.KEY_COMBATSLOT6, 54, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot6);
        combatSlot7 = new KeyBinding(ModI18n.KEY_COMBATSLOT7, 55, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot7);
        combatSlot8 = new KeyBinding(ModI18n.KEY_COMBATSLOT8, 56, ModI18n.CATEGORY_GENERAL);
        ClientRegistry.registerKeyBinding((KeyBinding)combatSlot8);
        keyBindsCombatbar = new KeyBinding[]{combatSlot1, combatSlot2, combatSlot3, combatSlot4, combatSlot5, combatSlot6, combatSlot7, combatSlot8};
    }

    public static boolean isShiftKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)340) || InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)344);
    }

    public static boolean isSpaceKeyDown() {
        return InputMappings.func_216506_a((long)Minecraft.func_71410_x().func_228018_at_().func_198092_i(), (int)32);
    }

    @SubscribeEvent
    public static void onPlayerJoins(EntityJoinWorldEvent event) {
        for (int i = 0; i < PREVIOUS_INVENTORY_KEYBINDS.length; ++i) {
            ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = -1;
        }
    }

    @SubscribeEvent
    public static void onPlayerLeaves(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        for (int i = 0; i < Minecraft.func_71410_x().field_71474_y.field_151456_ac.length; ++i) {
            KeyBinding kb = Minecraft.func_71410_x().field_71474_y.field_151456_ac[i];
            if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) continue;
            kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
        }
    }

    @SubscribeEvent
    public static void onPlayerUpdate(LivingEvent.LivingUpdateEvent event) {
        if (event.getEntity() instanceof ClientPlayerEntity && event.getEntityLiving() == Minecraft.func_71410_x().field_71439_g) {
            for (int i = 0; i < 8; ++i) {
                if (keyCooldown[i] <= 0) continue;
                int n = i;
                keyCooldown[n] = keyCooldown[n] - 1;
            }
        }
    }

    @SubscribeEvent
    public static void onMouseInput(InputEvent.MouseInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null || event.getAction() == 0) {
            return;
        }
        ModKeybindings.checkKeybindings((PlayerEntity)player);
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent.KeyInputEvent event) {
        Minecraft minecraft = Minecraft.func_71410_x();
        ClientPlayerEntity player = minecraft.field_71439_g;
        if (player == null) {
            return;
        }
        ModKeybindings.checkKeybindings((PlayerEntity)player);
    }

    private static void checkKeybindings(PlayerEntity player) {
        IAbilityData abilityDataProps = AbilityDataCapability.get((LivingEntity)player);
        IEntityStats entityStatsProps = EntityStatsCapability.get((LivingEntity)player);
        if (entityStatsProps.isInCombatMode()) {
            if (nextCombatBar.func_151468_f()) {
                WyNetwork.sendToServer(new CChangeCombatBarPacket(0));
            } else if (prevCombatBar.func_151468_f()) {
                WyNetwork.sendToServer(new CChangeCombatBarPacket(1));
            }
        }
        if (guiPlayer.func_151468_f()) {
            if (Minecraft.func_71410_x().field_71462_r != null) {
                return;
            }
            WyNetwork.sendToServer(new COpenPlayerScreenPacket());
        }
        if (enterCombatMode.func_151468_f()) {
            ModKeybindings.keybindsAssignment(entityStatsProps);
        }
        int j = keyBindsCombatbar.length;
        for (int i = 0; i < j; ++i) {
            if (!keyBindsCombatbar[i].func_151468_f()) continue;
            int k = i + abilityDataProps.getCombatBarSet() * 8;
            Object abl = abilityDataProps.getEquippedAbility(k);
            if (entityStatsProps.isInCombatMode() && abl != null) {
                if (((Ability)((Object)abl)).isOnCooldown() && !(((Ability)((Object)abl)).getCooldown() <= 10.0) || keyCooldown[i] > 0) continue;
                WyNetwork.sendToServer(new CUseAbilityPacket(k));
                ModKeybindings.keyCooldown[i] = 5;
                continue;
            }
            player.field_71071_by.field_70461_c = i;
        }
    }

    private static void keybindsAssignment(IEntityStats entityStatsProps) {
        entityStatsProps.setCombatMode(!entityStatsProps.isInCombatMode());
        if (entityStatsProps.isInCombatMode()) {
            for (int i = 0; i < Minecraft.func_71410_x().field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = Minecraft.func_71410_x().field_71474_y.field_151456_ac[i];
                ModKeybindings.PREVIOUS_INVENTORY_KEYBINDS[i] = kb.getKey().func_197937_c();
                kb.func_197979_b(InputMappings.func_197954_a((int)-1, (int)0));
            }
            KeyBinding.func_74508_b();
        } else {
            for (int i = 0; i < Minecraft.func_71410_x().field_71474_y.field_151456_ac.length; ++i) {
                KeyBinding kb = Minecraft.func_71410_x().field_71474_y.field_151456_ac[i];
                if (PREVIOUS_INVENTORY_KEYBINDS[i] == -1) {
                    kb.func_197979_b(InputMappings.func_197954_a((int)kb.func_197977_i().func_197937_c(), (int)0));
                    continue;
                }
                kb.func_197979_b(InputMappings.func_197954_a((int)PREVIOUS_INVENTORY_KEYBINDS[i], (int)0));
            }
            KeyBinding.func_74508_b();
        }
        WyNetwork.sendToServer(new CToggleCombatModePacket(entityStatsProps.isInCombatMode()));
    }

    static {
        PREVIOUS_INVENTORY_KEYBINDS = new int[]{-1, -1, -1, -1, -1, -1, -1, -1, -1, -1};
        keyCooldown = new int[8];
    }
}

