/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.items.weapons;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.SwordItem;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiImbuingAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityItemTier;
import xyz.pixelatedw.mineminenomi.api.helpers.AbilityHelper;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.haki.HakiDataCapability;
import xyz.pixelatedw.mineminenomi.data.entity.haki.IHakiData;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModAttributes;
import xyz.pixelatedw.mineminenomi.init.ModCreativeTabs;
import xyz.pixelatedw.mineminenomi.wypi.abilities.events.SetOnFireEvent;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class CoreSwordItem
extends SwordItem {
    public double damage = 1.0;
    public double speed = -2.4;
    public double range = 0.0;
    protected boolean isPoisonous = false;
    protected boolean isFireAspect = false;
    protected boolean isSlownessInducing = false;
    protected boolean isStackable = false;
    protected int poisonTimer = 100;
    protected int fireAspectTimer = 10;
    protected int slownessTimer = 100;
    protected int frostBiteTimer = 0;
    private boolean isBlunt = false;
    private boolean rustImmunity = false;
    private boolean independentImbuing = false;
    private Ingredient repairIngredient;
    private IItemPropertyGetter hakiProperty = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 0.0f;
        }
        float hasHakiActive = 0.0f;
        if (livingEntity instanceof PlayerEntity) {
            IAbilityData props = AbilityDataCapability.get(livingEntity);
            boolean mainHandFlag = livingEntity.func_184614_ca() == itemStack;
            boolean offHandFlag = livingEntity.func_184592_cb() == itemStack;
            BusoshokuHakiImbuingAbility ability = props.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
            boolean hakiActiveFlag = ability != null && ability.isContinuous();
            hasHakiActive = (mainHandFlag || offHandFlag) && hakiActiveFlag ? 1.0f : 0.0f;
        } else if (livingEntity instanceof OPEntity) {
            hasHakiActive = ((OPEntity)livingEntity).hasBusoHaki() ? 1.0f : 0.0f;
        }
        return hasHakiActive;
    };
    private IItemPropertyGetter sheathedProperty = (itemStack, world, livingEntity) -> {
        if (livingEntity == null) {
            return 1.0f;
        }
        boolean mainHandFlag = livingEntity.func_184614_ca() != itemStack;
        boolean offHandFlag = livingEntity.func_184592_cb() != itemStack;
        return mainHandFlag && offHandFlag ? 1.0f : 0.0f;
    };
    protected static final UUID ATTACK_RANGE_MODIFIER = UUID.fromString("06256896-00c1-45b4-bc71-514ee36310bd");

    public boolean isBookEnchantable(ItemStack stack, ItemStack book) {
        return true;
    }

    public CoreSwordItem(Item.Properties props, int damage) {
        super((IItemTier)AbilityItemTier.WEAPON, damage, 0.0f, props);
        this.damage = damage - 1;
        this.func_185043_a(new ResourceLocation("haki"), this.hakiProperty);
        this.func_185043_a(new ResourceLocation("sheathed"), this.sheathedProperty);
    }

    public CoreSwordItem(int damage, int durability) {
        super((IItemTier)AbilityItemTier.WEAPON, damage, 0.0f, new Item.Properties().func_200916_a(ModCreativeTabs.WEAPONS).func_200917_a(1).func_200915_b(durability));
        this.damage = damage - 1;
        this.func_185043_a(new ResourceLocation("haki"), this.hakiProperty);
        this.func_185043_a(new ResourceLocation("sheathed"), this.sheathedProperty);
    }

    public void func_77663_a(ItemStack itemStack, World world, Entity entity, int par4, boolean par5) {
        if (!itemStack.func_77942_o()) {
            itemStack.func_77982_d(new CompoundNBT());
            itemStack.func_77978_p().func_74780_a("multiplier", 1.0);
            itemStack.func_77978_p().func_74780_a("extraDamage", 0.0);
        }
        if (!world.field_72995_K) {
            IEntityStats statProps = EntityStatsCapability.get((LivingEntity)entity);
            IAbilityData abilityProps = AbilityDataCapability.get((LivingEntity)((PlayerEntity)entity));
            double multiplier = 1.0;
            double extraDamage = 0.0;
            BusoshokuHakiImbuingAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
            boolean hakiActiveFlag = ability != null && ability.isContinuous();
            IHakiData hakiProps = HakiDataCapability.get((LivingEntity)((PlayerEntity)entity));
            if (hakiActiveFlag) {
                multiplier += (double)Math.min(hakiProps.getBusoshokuImbuingHakiExp() / 300.0f, 0.34f);
                extraDamage = hakiProps.getBusoshokuImbuingHakiExp() / 100.0f * 8.0f;
            }
            if (statProps.isSwordsman()) {
                multiplier += 0.2;
            }
            itemStack.func_77978_p().func_74780_a("multiplier", multiplier);
            itemStack.func_77978_p().func_74780_a("extraDamage", extraDamage);
            if (itemStack.func_77978_p().func_74767_n("isClone") && !itemStack.func_77978_p().func_74767_n("hasCloneTag")) {
                itemStack.func_200302_a((ITextComponent)new StringTextComponent(TextFormatting.RESET + itemStack.func_200301_q().func_150254_d() + " (Replica)"));
                itemStack.func_77978_p().func_74757_a("hasCloneTag", true);
            }
        }
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        return new ActionResult(ActionResultType.PASS, (Object)player.func_184586_b(hand));
    }

    public int func_77619_b() {
        return 14;
    }

    public boolean func_77644_a(ItemStack itemStack, LivingEntity target, LivingEntity attacker) {
        SetOnFireEvent event;
        boolean hasBusoHaki;
        IAbilityData abilityProps = AbilityDataCapability.get(attacker);
        BusoshokuHakiImbuingAbility ability = abilityProps.getEquippedAbility(BusoshokuHakiImbuingAbility.INSTANCE);
        boolean bl = hasBusoHaki = ability != null && ability.isContinuous();
        if (!hasBusoHaki) {
            int damage = itemStack.func_196082_o().func_74767_n("isClone") ? 3 : 1;
            itemStack.func_222118_a(damage, attacker, entity -> entity.func_213361_c(EquipmentSlotType.MAINHAND));
        }
        if (hasBusoHaki || this.isBlunt) {
            Item mainShield = target.func_184614_ca().func_77973_b();
            Item secondaryShield = target.func_184592_cb().func_77973_b();
            if (target instanceof PlayerEntity && Math.random() > 0.5 && (mainShield.equals(Items.field_185159_cQ) || secondaryShield.equals(Items.field_185159_cQ))) {
                ((PlayerEntity)target).func_184811_cZ().func_185145_a(Items.field_185159_cQ, 100);
                target.func_184602_cy();
                target.field_70170_p.func_72960_a((Entity)attacker, (byte)30);
            }
        }
        if (this.isPoisonous) {
            target.func_195064_c(new EffectInstance(Effects.field_76436_u, this.poisonTimer, 0));
        }
        if (this.isFireAspect && !MinecraftForge.EVENT_BUS.post((Event)(event = new SetOnFireEvent(attacker, target, this.fireAspectTimer)))) {
            target.func_70015_d(this.fireAspectTimer);
        }
        if (this.isSlownessInducing) {
            if (this.isStackable) {
                if (target.func_70644_a(Effects.field_76421_d)) {
                    int timer = target.func_70660_b(Effects.field_76421_d).func_76459_b();
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, timer + this.slownessTimer, 0));
                } else {
                    target.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTimer, 0));
                }
            } else {
                target.func_195064_c(new EffectInstance(Effects.field_76421_d, this.slownessTimer, 0));
            }
        }
        if (this.frostBiteTimer > 0) {
            AbilityHelper.addFrostbite(target, attacker, this.frostBiteTimer);
        }
        return true;
    }

    public <T extends CoreSwordItem> T setIsPoisonous() {
        this.isPoisonous = true;
        this.poisonTimer = 100;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setIsPoisonous(int timer) {
        this.isPoisonous = true;
        this.poisonTimer = timer;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setSwordSpeed(double speed) {
        this.speed = speed;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setRepairIngredient(Ingredient ingredient) {
        this.repairIngredient = ingredient;
        return (T)((Object)this);
    }

    public Ingredient getRepairIngredient() {
        return this.repairIngredient;
    }

    public <T extends CoreSwordItem> T setBlunt() {
        this.isBlunt = true;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setSharp() {
        this.isBlunt = false;
        return (T)((Object)this);
    }

    public boolean isBlunt() {
        return this.isBlunt;
    }

    public <T extends CoreSwordItem> T setRustImmunity() {
        this.rustImmunity = true;
        return (T)((Object)this);
    }

    public boolean isRustImmune() {
        return this.rustImmunity;
    }

    public <T extends CoreSwordItem> T setIsFireAspect() {
        this.isFireAspect = true;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setIsFireAspect(int timer) {
        this.isFireAspect = true;
        this.fireAspectTimer = timer;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setIsSlownessInducing() {
        this.isSlownessInducing = true;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setIsSlownessInducing(int timer) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setFrosbiteTimer(int timer) {
        this.frostBiteTimer = timer;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setIsSlownessInducing(int timer, boolean isStackable) {
        this.isSlownessInducing = true;
        this.slownessTimer = timer;
        this.isStackable = isStackable;
        return (T)((Object)this);
    }

    public <T extends CoreSwordItem> T setExtraAttackRange(double range) {
        this.range = range;
        return (T)((Object)this);
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EquipmentSlotType equipmentSlot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (equipmentSlot == EquipmentSlotType.MAINHAND) {
            double multiplier = 1.0;
            double extraDamage = 0.0;
            if (stack.func_77978_p() != null) {
                multiplier = stack.func_77978_p().func_74764_b("multiplier") ? stack.func_77978_p().func_74769_h("multiplier") : 1.0;
                double d = extraDamage = stack.func_77978_p().func_74764_b("extraDamage") ? stack.func_77978_p().func_74769_h("extraDamage") : 0.0;
                if (stack.func_77978_p().func_74767_n("isClone")) {
                    multiplier /= 1.25;
                }
            }
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)Math.round(this.damage * multiplier + extraDamage), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Speed modifier", this.speed, AttributeModifier.Operation.ADDITION));
            if (this.range > 0.0) {
                multimap.put((Object)ModAttributes.ATTACK_RANGE.func_111108_a(), (Object)new AttributeModifier(ATTACK_RANGE_MODIFIER, "Weapon modifier", this.range, AttributeModifier.Operation.ADDITION));
            }
        }
        return multimap;
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        try {
            return this.repairIngredient.test(repair);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public boolean usesIndependentImbuing() {
        return this.independentImbuing;
    }

    public void setIndependentImbuing() {
        this.independentImbuing = true;
    }
}

