/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.mixins;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import xyz.pixelatedw.mineminenomi.api.ZoanInfo;
import xyz.pixelatedw.mineminenomi.api.helpers.AttributeHelper;
import xyz.pixelatedw.mineminenomi.api.helpers.MorphHelper;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.DevilFruitCapability;
import xyz.pixelatedw.mineminenomi.data.entity.devilfruit.IDevilFruit;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@Mixin(value={PlayerEntity.class})
public abstract class PlayerEntityMixin
extends LivingEntity {
    public PlayerEntityMixin(EntityType<? extends LivingEntity> type, World world) {
        super(type, world);
    }

    @ModifyConstant(method={"attackTargetEntityWithCurrentItem(Lnet/minecraft/entity/Entity;)V"}, constant={@Constant(doubleValue=9.0)})
    private double getActualAttackRange(double attackRange) {
        return AttributeHelper.getSquaredAttackRangeDistance(this, attackRange);
    }

    @Inject(method={"getSize"}, at={@At(value="HEAD")}, cancellable=true)
    public void getSize(Pose pose, CallbackInfoReturnable<EntitySize> callback) {
        ZoanInfo info;
        IDevilFruit props = DevilFruitCapability.get(this);
        if (!WyHelper.isNullOrEmpty(props.getZoanPoint()) && (info = MorphHelper.getZoanInfo(this)) != null && info.getSizes() != null && info.getSizes().containsKey(this.func_213283_Z()) && info.getSizes().get(this.func_213283_Z()) != null) {
            callback.setReturnValue((Object)info.getSizes().get(this.func_213283_Z()));
        }
    }

    @Inject(method={"attackTargetEntityWithCurrentItem"}, at={@At(value="INVOKE", target="Lnet/minecraft/entity/player/PlayerEntity;spawnSweepParticles()V", shift=At.Shift.AFTER)})
    public void attackTargetEntityWithCurrentItem(Entity targetEntity, CallbackInfo callback) {
        targetEntity.field_70172_ad = 0;
        targetEntity.func_70097_a((DamageSource)new EntityDamageSource("sweep_damage", (Entity)this), 0.0f);
    }
}

