/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.packets.server;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import xyz.pixelatedw.mineminenomi.data.world.ExtendedWorldData;

public class SSyncWorldDataPacket {
    private CompoundNBT data;

    public SSyncWorldDataPacket() {
    }

    public SSyncWorldDataPacket(ExtendedWorldData worldData) {
        this.data = new CompoundNBT();
        this.data = worldData.func_189551_b(this.data);
    }

    public void encode(PacketBuffer buffer) {
        buffer.func_150786_a(this.data);
    }

    public static SSyncWorldDataPacket decode(PacketBuffer buffer) {
        SSyncWorldDataPacket msg = new SSyncWorldDataPacket();
        msg.data = buffer.func_150793_b();
        return msg;
    }

    public static void handle(SSyncWorldDataPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (ctx.get().getDirection() == NetworkDirection.PLAY_TO_CLIENT) {
            ctx.get().enqueueWork(() -> ClientHandler.handle(message));
        }
        ctx.get().setPacketHandled(true);
    }

    public static class ClientHandler {
        @OnlyIn(value=Dist.CLIENT)
        public static void handle(SSyncWorldDataPacket message) {
            ClientWorld world = Minecraft.func_71410_x().field_71441_e;
            ExtendedWorldData worldData = ExtendedWorldData.get((World)world);
            if (worldData != null) {
                worldData.func_76184_a(message.data);
            }
        }
    }
}

