/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.particles.data;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.network.PacketBuffer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;

public class GenericParticleData
implements IParticleData {
    public static final IParticleData.IDeserializer<GenericParticleData> DESERIALIZER = new IParticleData.IDeserializer<GenericParticleData>(){

        public GenericParticleData deserialize(ParticleType<GenericParticleData> particleType, StringReader stringReader) throws CommandSyntaxException {
            stringReader.expect(' ');
            float red = stringReader.readFloat();
            float green = stringReader.readFloat();
            float blue = stringReader.readFloat();
            float alpha = stringReader.readFloat();
            float size = stringReader.readFloat();
            int life = stringReader.readInt();
            int ID = stringReader.readInt();
            boolean hasRotation = stringReader.readBoolean();
            boolean hasMotionDecat = stringReader.readBoolean();
            boolean shouldHideTooClose = stringReader.readBoolean();
            boolean shouldHideFromOthers = stringReader.readBoolean();
            double motionX = stringReader.readDouble();
            double motionY = stringReader.readDouble();
            double motionZ = stringReader.readDouble();
            GenericParticleData data = new GenericParticleData(particleType);
            data.setColor(red, green, blue, alpha);
            data.setMotion(motionX, motionY, motionZ);
            data.setSize(size);
            data.setLife(life);
            data.setEntityID(ID);
            if (hasRotation) {
                data.setHasRotation();
            }
            data.setHasMotionDecay(hasMotionDecat);
            if (shouldHideTooClose) {
                data.hideTooClose();
            }
            if (shouldHideFromOthers) {
                data.hideFromOthers();
            }
            return data;
        }

        public GenericParticleData read(ParticleType<GenericParticleData> particleType, PacketBuffer packetBuffer) {
            float red = packetBuffer.readFloat();
            float green = packetBuffer.readFloat();
            float blue = packetBuffer.readFloat();
            float alpha = packetBuffer.readFloat();
            float size = packetBuffer.readFloat();
            int life = packetBuffer.readInt();
            int ID = packetBuffer.readInt();
            boolean hasRotation = packetBuffer.readBoolean();
            boolean hasMotionDecat = packetBuffer.readBoolean();
            boolean shouldHideTooClose = packetBuffer.readBoolean();
            boolean shouldHideFromOthers = packetBuffer.readBoolean();
            double motionX = packetBuffer.readDouble();
            double motionY = packetBuffer.readDouble();
            double motionZ = packetBuffer.readDouble();
            GenericParticleData data = new GenericParticleData(particleType);
            data.setColor(red, green, blue, alpha);
            data.setMotion(motionX, motionY, motionZ);
            data.setSize(size);
            data.setLife(life);
            data.setEntityID(ID);
            if (hasRotation) {
                data.setHasRotation();
            }
            data.setHasMotionDecay(hasMotionDecat);
            if (shouldHideTooClose) {
                data.hideTooClose();
            }
            if (shouldHideFromOthers) {
                data.hideFromOthers();
            }
            return data;
        }
    };
    private float red = 1.0f;
    private float green = 1.0f;
    private float blue = 1.0f;
    private double motionX;
    private double motionY;
    private double motionZ;
    private float alpha = 1.0f;
    private float size = 1.0f;
    private int life = 10;
    private int entityID = 0;
    private boolean hasRotation = false;
    private boolean hasMotionDecay = true;
    private boolean shouldHideTooClose = false;
    private boolean shouldHideFromOthers = false;
    private ParticleType type;

    public GenericParticleData(ParticleType type) {
        this.type = type;
    }

    public ParticleType<?> func_197554_b() {
        return this.type;
    }

    public void func_197553_a(PacketBuffer buffer) {
        buffer.writeFloat(this.red);
        buffer.writeFloat(this.green);
        buffer.writeFloat(this.blue);
        buffer.writeFloat(this.alpha);
        buffer.writeFloat(this.size);
        buffer.writeInt(this.life);
        buffer.writeInt(this.entityID);
        buffer.writeBoolean(this.hasRotation);
        buffer.writeBoolean(this.hasMotionDecay);
        buffer.writeBoolean(this.shouldHideTooClose);
        buffer.writeBoolean(this.shouldHideFromOthers);
        buffer.writeDouble(this.motionX);
        buffer.writeDouble(this.motionY);
        buffer.writeDouble(this.motionZ);
    }

    public GenericParticleData setMotion(double motionX, double motionY, double motionZ) {
        this.motionX = motionX;
        this.motionY = motionY;
        this.motionZ = motionZ;
        return this;
    }

    public GenericParticleData setColor(float red, float green, float blue) {
        return this.setColor(red, green, blue, 1.0f);
    }

    public GenericParticleData setColor(float red, float green, float blue, float alpha) {
        this.red = red;
        this.green = green;
        this.blue = blue;
        this.alpha = alpha;
        return this;
    }

    public GenericParticleData setSize(float size) {
        this.size = size;
        return this;
    }

    public GenericParticleData setLife(int life) {
        this.life = life;
        return this;
    }

    public GenericParticleData setEntityID(int id) {
        this.entityID = id;
        return this;
    }

    public GenericParticleData setHasRotation() {
        this.hasRotation = true;
        return this;
    }

    public GenericParticleData setHasMotionDecay(boolean flag) {
        this.hasMotionDecay = flag;
        return this;
    }

    public GenericParticleData hideFromOthers() {
        this.shouldHideFromOthers = true;
        return this;
    }

    public GenericParticleData hideTooClose() {
        this.shouldHideTooClose = true;
        return this;
    }

    public boolean getHideTooClose() {
        return this.shouldHideTooClose;
    }

    public boolean getHideFromOthers() {
        return this.shouldHideFromOthers;
    }

    public String func_197555_a() {
        return this.func_197554_b().getRegistryName().toString();
    }

    public float getRed() {
        return this.red;
    }

    public float getEntityID() {
        return this.entityID;
    }

    public float getGreen() {
        return this.green;
    }

    public float getBlue() {
        return this.blue;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public float getSize() {
        return this.size;
    }

    public int getLife() {
        return this.life;
    }

    public double getMotionX() {
        return this.motionX;
    }

    public double getMotionY() {
        return this.motionY;
    }

    public double getMotionZ() {
        return this.motionZ;
    }

    public boolean hasRotation() {
        return this.hasRotation;
    }

    public boolean hasMotionDecay() {
        return this.hasMotionDecay;
    }
}

