/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.quests.blackleg;

import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.AntiMannerKickCourseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.ConcasseAbility;
import xyz.pixelatedw.mineminenomi.abilities.blackleg.PartyTableKickCourseAbility;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.api.quests.objectives.Objective;
import xyz.pixelatedw.mineminenomi.entities.projectiles.blackleg.ExtraHachisProjectile;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.quests.objectives.HitEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.KillEntityObjective;
import xyz.pixelatedw.mineminenomi.quests.objectives.SharedKillChecks;
import xyz.pixelatedw.mineminenomi.quests.objectives.TimedHitEntityObjective;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;
import xyz.pixelatedw.mineminenomi.wypi.network.packets.client.CSyncAbilityDataPacket;

public class BlackLegTrial03Quest
extends Quest {
    private static final HitEntityObjective.ICheckHit EXTRA_HACHIS_HIT_CHECK = (player, target, source, amount) -> source.func_76364_f() instanceof ExtraHachisProjectile;
    private Objective objective01 = new TimedHitEntityObjective("Hit %s enemies using Extra Hachis at the same time", 3, 3, EXTRA_HACHIS_HIT_CHECK);
    private Objective objective02 = new KillEntityObjective("Kill %s enemies using Concasse", 10, SharedKillChecks.IS_KICKING.and(SharedKillChecks.checkAbilitySource(ConcasseAbility.INSTANCE)));

    public BlackLegTrial03Quest() {
        super("black_leg_trial_03", "Trial: Courses");
        this.addRequirement(ModQuests.BLACK_LEG_TRIAL_02);
        this.addObjectives(this.objective01, this.objective02);
        this.onCompleteEvent = this::giveReward;
    }

    public boolean giveReward(PlayerEntity player) {
        IAbilityData props = AbilityDataCapability.get((LivingEntity)player);
        props.addUnlockedAbility(AntiMannerKickCourseAbility.INSTANCE);
        props.addUnlockedAbility(PartyTableKickCourseAbility.INSTANCE);
        WyNetwork.sendToServer(new CSyncAbilityDataPacket(props));
        return true;
    }
}

