/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.abilities;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.awt.Color;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import xyz.pixelatedw.mineminenomi.entities.projectiles.hie.IceBlockAvalancheProjectile;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.models.CubeModel;
import xyz.pixelatedw.mineminenomi.wypi.abilities.projectiles.AbilityProjectileEntity;
import xyz.pixelatedw.mineminenomi.wypi.abilities.renderers.AbilityProjectileRenderer;

public class IceBlockAvalancheRenderer
extends AbilityProjectileRenderer {
    public IceBlockAvalancheRenderer(EntityRendererManager renderManager, EntityModel model) {
        super(renderManager, model);
    }

    public void render(AbilityProjectileEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        if (entityIn.field_70173_aa > 12) {
            IceBlockAvalancheProjectile e;
            if (entityIn instanceof IceBlockAvalancheProjectile && !(e = (IceBlockAvalancheProjectile)entityIn).getFinalized() && this.getScale().field_72450_a + (double)(e.field_70173_aa / 5) < 30.0) {
                this.setScale(8 + e.field_70173_aa / 5, 8 + e.field_70173_aa / 5, 8 + e.field_70173_aa / 5);
            }
            super.render(entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }
    }

    public static class Factory
    implements IRenderFactory<AbilityProjectileEntity> {
        private EntityModel model = new CubeModel();
        private double scaleX = 1.0;
        private double scaleY = 1.0;
        private double scaleZ = 1.0;
        private double red = 255.0;
        private double green = 255.0;
        private double blue = 255.0;
        private double alpha = 255.0;
        private ResourceLocation texture;

        public Factory(EntityModel model) {
            this.model = model;
        }

        public Factory setTexture(String textureName) {
            this.texture = new ResourceLocation("mineminenomi", "textures/models/projectiles/" + textureName + ".png");
            return this;
        }

        public Factory setColor(double red, double green, double blue, double alpha) {
            this.red = red;
            this.green = green;
            this.blue = blue;
            this.alpha = alpha;
            return this;
        }

        public Factory setColor(String hex) {
            Color color = WyHelper.hexToRGB(hex);
            this.red = color.getRed();
            this.green = color.getGreen();
            this.blue = color.getBlue();
            this.alpha = color.getAlpha();
            return this;
        }

        public Factory setAlpha(double alpha) {
            this.alpha = alpha;
            return this;
        }

        public Factory setScale(double scale) {
            this.scaleY = this.scaleZ = scale;
            this.scaleX = this.scaleZ;
            return this;
        }

        public Factory setScale(double scaleX, double scaleY, double scaleZ) {
            this.scaleX = scaleX;
            this.scaleY = scaleY;
            this.scaleZ = scaleZ;
            return this;
        }

        public EntityRenderer<? super AbilityProjectileEntity> createRenderFor(EntityRendererManager manager) {
            IceBlockAvalancheRenderer renderer = new IceBlockAvalancheRenderer(manager, this.model);
            renderer.setTexture(this.texture);
            renderer.setScale(this.scaleX, this.scaleY, this.scaleZ);
            renderer.setColor(this.red, this.green, this.blue, this.alpha);
            return renderer;
        }
    }
}

