/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.renderers.layers;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.IHasArm;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.HandSide;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiFullBodyHardeningAbility;
import xyz.pixelatedw.mineminenomi.abilities.haki.BusoshokuHakiHardeningAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.AbilityOverlay;
import xyz.pixelatedw.mineminenomi.api.abilities.IBodyOverlayAbility;
import xyz.pixelatedw.mineminenomi.api.abilities.IPunchOverlayAbility;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.entities.mobs.OPEntity;
import xyz.pixelatedw.mineminenomi.init.ModRenderTypes;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.AbilityDataCapability;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;

public class BodyCoatingLayer<T extends LivingEntity, M extends EntityModel<T>>
extends LayerRenderer<T, M> {
    public BodyCoatingLayer(IEntityRenderer renderer) {
        super(renderer);
    }

    public void render(MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight, T entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
        IVertexBuilder vertex = null;
        if (entity instanceof PlayerEntity) {
            IEntityStats props = EntityStatsCapability.get(entity);
            IAbilityData abilityProps = AbilityDataCapability.get(entity);
            for (Ability ability : abilityProps.getEquippedAbilities()) {
                float alpha;
                float blue;
                float green;
                float red;
                AbilityOverlay overlay;
                if (ability == null || !ability.isContinuous()) continue;
                if (ability instanceof IPunchOverlayAbility && this.func_215332_c() instanceof IHasArm) {
                    overlay = ((IPunchOverlayAbility)((Object)ability)).getPunchOverlay((LivingEntity)entity);
                    red = (float)overlay.getColor().getRed() / 255.0f;
                    green = (float)overlay.getColor().getGreen() / 255.0f;
                    blue = (float)overlay.getColor().getBlue() / 255.0f;
                    alpha = (float)overlay.getColor().getAlpha() / 255.0f;
                    if (overlay.getTexture() != null) {
                        vertex = buffer.getBuffer(ModRenderTypes.getAbilityHand(overlay.getTexture()));
                    } else {
                        IVertexBuilder iVertexBuilder = vertex = overlay.getRenderType().equals((Object)AbilityOverlay.RenderType.ENERGY) ? buffer.getBuffer(ModRenderTypes.ENERGY) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR);
                    }
                    if (props.isBlackLeg()) {
                        ((PlayerModel)this.func_215332_c()).field_178731_d.func_228309_a_(matrixStack, vertex, packedLight, packedLight, red, green, blue, alpha);
                        continue;
                    }
                    boolean isLeftHanded = false;
                    if (entity instanceof PlayerEntity) {
                        isLeftHanded = ((PlayerEntity)entity).func_184591_cq() == HandSide.LEFT;
                    } else if (entity instanceof MobEntity) {
                        isLeftHanded = ((MobEntity)entity).func_184638_cS();
                    }
                    if (isLeftHanded) {
                        ((PlayerModel)this.func_215332_c()).field_178734_a.func_228309_a_(matrixStack, vertex, packedLight, packedLight, red, green, blue, alpha);
                        continue;
                    }
                    ((PlayerModel)this.func_215332_c()).field_178732_b.func_228309_a_(matrixStack, vertex, packedLight, packedLight, red, green, blue, alpha);
                    continue;
                }
                if (!(ability instanceof IBodyOverlayAbility)) continue;
                overlay = ((IBodyOverlayAbility)((Object)ability)).getBodyOverlay();
                red = (float)overlay.getColor().getRed() / 255.0f;
                green = (float)overlay.getColor().getGreen() / 255.0f;
                blue = (float)overlay.getColor().getBlue() / 255.0f;
                alpha = (float)overlay.getColor().getAlpha() / 255.0f;
                vertex = overlay.getTexture() != null ? buffer.getBuffer(ModRenderTypes.getAbilityBody(overlay.getTexture())) : (overlay.getRenderType().equals((Object)AbilityOverlay.RenderType.ENERGY) ? buffer.getBuffer(ModRenderTypes.ENERGY) : buffer.getBuffer(ModRenderTypes.TRANSPARENT_COLOR));
                this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha);
            }
        } else if (entity instanceof OPEntity) {
            OPEntity opEntity = (OPEntity)entity;
            if (opEntity.hasBusoHaki()) {
                AbilityOverlay overlay = BusoshokuHakiHardeningAbility.INSTANCE.getPunchOverlay((LivingEntity)entity);
                float red = (float)overlay.getColor().getRed() / 255.0f;
                float green = (float)overlay.getColor().getGreen() / 255.0f;
                float blue = (float)overlay.getColor().getBlue() / 255.0f;
                float alpha = (float)overlay.getColor().getAlpha() / 255.0f;
                vertex = buffer.getBuffer(ModRenderTypes.getAbilityBody(overlay.getTexture()));
                ((BipedModel)this.func_215332_c()).field_178723_h.func_228309_a_(matrixStack, vertex, packedLight, packedLight, red, green, blue, alpha + 0.2f);
            } else if (opEntity.hasFullbodyHaki()) {
                AbilityOverlay overlay = BusoshokuHakiFullBodyHardeningAbility.INSTANCE.getBodyOverlay();
                float red = (float)overlay.getColor().getRed() / 255.0f;
                float green = (float)overlay.getColor().getGreen() / 255.0f;
                float blue = (float)overlay.getColor().getBlue() / 255.0f;
                float alpha = (float)overlay.getColor().getAlpha() / 255.0f;
                vertex = buffer.getBuffer(ModRenderTypes.getAbilityBody(overlay.getTexture()));
                this.func_215332_c().func_225598_a_(matrixStack, vertex, packedLight, OverlayTexture.field_229196_a_, red, green, blue, alpha + 0.2f);
            }
        }
    }
}

