/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.client.gui.GuiUtils;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.init.ModI18n;
import xyz.pixelatedw.mineminenomi.init.ModResources;
import xyz.pixelatedw.mineminenomi.packets.client.CFinishCCPacket;
import xyz.pixelatedw.mineminenomi.screens.extra.TexturedIconButton;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

@OnlyIn(value=Dist.CLIENT)
public class CharacterCreatorScreen
extends Screen {
    private int page;
    private int maxOpt;
    private int renderTick = 0;
    private int minkTextureId = 0;
    private int[] options = new int[3];
    private final String[] FACTIONS = new String[]{"Random", "pirate", "marine", "bounty_hunter", "revolutionary"};
    private final String[] RACES = new String[]{"Random", "human", "fishman", "cyborg", "mink"};
    private final String[] STYLES = new String[]{"Random", "swordsman", "sniper", "doctor", "art_of_weather", "brawler", "black_leg"};
    private TexturedIconButton factionButton;
    private TexturedIconButton raceButton;
    private TexturedIconButton styleButton;
    private boolean hasRandomizedRace;

    public CharacterCreatorScreen(boolean hasRandomizedRace) {
        super((ITextComponent)new StringTextComponent(""));
        this.hasRandomizedRace = hasRandomizedRace;
    }

    public void render(int x, int y, float f) {
        this.renderBackground();
        int posX = this.width / 2;
        int posY = this.height / 2;
        Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BLANK);
        GuiUtils.drawTexturedModalRect((int)(posX - 110), (int)(posY - 80), (int)0, (int)0, (int)256, (int)256, (float)0.0f);
        if (this.page == 0) {
            if (this.getSelectedFactionId() == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.RANDOM);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Random", posX + 269, posY + 190, 3.0);
            } else if (this.getSelectedFactionId() == 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.PIRATE_ICON);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Pirate", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedFactionId() == 2) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.MARINE_ICON);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Marine", posX + 269, posY + 190, 3.0);
            } else if (this.getSelectedFactionId() == 3) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BOUNTY_HUNTER_ICON);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Bounty", posX + 215, posY + 150, 2.7);
                this.drawCategory("Hunter", posX + 248, posY + 170, 2.7);
            } else if (this.getSelectedFactionId() == 4) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.REVOLUTIONARY_ARMY_ICON);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Revolutionary", posX + 165, posY + 85, 2.2);
                this.drawCategory("Army", posX + 190, posY + 100, 2.2);
            }
        }
        if (this.page == 1) {
            if (this.getSelectedRaceId() == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.RANDOM);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Random", posX + 269, posY + 190, 3.0);
            } else if (this.getSelectedRaceId() == 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.HUMAN);
                GuiUtils.drawTexturedModalRect((int)(posX - 118), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Human", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedRaceId() == 2) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.FISHMAN);
                GuiUtils.drawTexturedModalRect((int)(posX - 118), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Fishman", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedRaceId() == 3) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.CYBORG);
                GuiUtils.drawTexturedModalRect((int)(posX - 118), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Cyborg", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedRaceId() == 4) {
                ResourceLocation[] minkTexture = new ResourceLocation[]{ModResources.MINK1, ModResources.MINK2, ModResources.MINK3};
                if (this.renderTick % 150 == 0) {
                    this.minkTextureId = this.minkTextureId == 2 ? 0 : ++this.minkTextureId;
                }
                Minecraft.func_71410_x().func_110434_K().func_110577_a(minkTexture[this.minkTextureId]);
                GuiUtils.drawTexturedModalRect((int)(posX - 118), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Mink", posX + 268, posY + 190, 3.0);
            }
        }
        if (this.page == 2) {
            if (this.getSelectedStyleId() == 0) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.RANDOM);
                GuiUtils.drawTexturedModalRect((int)(posX - 115), (int)(posY - 110), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Random", posX + 269, posY + 190, 3.0);
            } else if (this.getSelectedStyleId() == 1) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.SWORDSMAN);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Swordsman", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedStyleId() == 2) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.SNIPER);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Sniper", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedStyleId() == 3) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.DOCTOR);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Doctor", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedStyleId() == 4) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.ART_OF_WEATHER);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Art of Weather", posX + 180, posY + 100, 2.3);
            } else if (this.getSelectedStyleId() == 5) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BRAWLER);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Brawler", posX + 268, posY + 190, 3.0);
            } else if (this.getSelectedStyleId() == 6) {
                Minecraft.func_71410_x().func_110434_K().func_110577_a(ModResources.BLACK_LEG);
                GuiUtils.drawTexturedModalRect((int)(posX - 113), (int)(posY - 115), (int)0, (int)0, (int)256, (int)256, (float)1.0f);
                this.drawCategory("Black Leg", posX + 268, posY + 190, 3.0);
            }
        }
        ++this.renderTick;
        super.render(x, y, f);
    }

    public void init() {
        int posX = (this.width - 256) / 2;
        int posY = (this.height - 256) / 2;
        int posY2 = posY + 65;
        String msg = new TranslationTextComponent(ModI18n.FACTION_NAME, new Object[0]).func_150254_d();
        this.factionButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX - 58, posY2, 90, 36, msg, btn -> {
            this.page = 0;
            this.resetButtonState();
            this.factionButton.setIsPressed(true);
        });
        this.factionButton = this.factionButton.setTextureInfo(posX - 58, posY + 65, 90, 60).setTextInfo(posX + 50, posY + 169, 1.75);
        this.addButton((Widget)this.factionButton);
        msg = new TranslationTextComponent(ModI18n.RACE_NAME, new Object[0]).func_150254_d();
        this.raceButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX - 58, posY2 += 45, 90, 36, msg, btn -> {
            this.page = 1;
            this.resetButtonState();
            this.raceButton.setIsPressed(true);
        });
        this.raceButton = this.raceButton.setTextureInfo(posX - 58, posY + 110, 90, 60).setTextInfo(posX + 50, posY + 214, 1.75);
        if (!this.hasRandomizedRace) {
            this.addButton((Widget)this.raceButton);
            posY2 += 45;
        }
        msg = new TranslationTextComponent(ModI18n.STYLE_NAME, new Object[0]).func_150254_d();
        this.styleButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX - 58, posY2, 90, 36, msg, btn -> {
            this.page = 2;
            this.resetButtonState();
            this.styleButton.setIsPressed(true);
        });
        this.styleButton = this.styleButton.setTextureInfo(posX - 58, posY2, 90, 60).setTextInfo(posX + 50, posY2 + 102, 1.75);
        this.addButton((Widget)this.styleButton);
        TexturedIconButton nextButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_RIGHT, posX + 215, posY + 80, 24, 100, "", btn -> this.increaseSelectedPage());
        nextButton = nextButton.setTextureInfo(posX + 211, posY + 66, 32, 128);
        this.addButton((Widget)nextButton);
        TexturedIconButton prevButton = new TexturedIconButton(ModResources.BIG_WOOD_BUTTON_LEFT, posX + 45, posY + 80, 24, 100, "", btn -> this.decreaseSelectedPage());
        prevButton = prevButton.setTextureInfo(posX + 41, posY + 66, 32, 128);
        this.addButton((Widget)prevButton);
        TexturedIconButton finishButton = new TexturedIconButton(ModResources.BLANK2_SIMPLE, posX + 100, posY + 200, 90, 36, "Finish", btn -> this.completeCreation());
        finishButton = finishButton.setTextureInfo(posX + 100, posY + 200, 90, 60).setTextInfo(posX + 217, posY + 304, 1.75);
        this.addButton((Widget)finishButton);
    }

    private void resetButtonState() {
        this.factionButton.setIsPressed(false);
        this.raceButton.setIsPressed(false);
        this.styleButton.setIsPressed(false);
    }

    private void completeCreation() {
        Minecraft.func_71410_x().func_147108_a(null);
        WyNetwork.sendToServer(new CFinishCCPacket(this.getSelectedFactionId(), this.getSelectedRaceId(), this.getSelectedStyleId()));
    }

    public void tick() {
        if (this.page == 0) {
            this.maxOpt = this.FACTIONS.length;
        }
        if (this.page == 1) {
            this.maxOpt = this.RACES.length;
        }
        if (this.page == 2) {
            this.maxOpt = this.STYLES.length;
        }
    }

    public boolean doesGuiPauseGame() {
        return false;
    }

    private void drawCategory(String text, int posX, int posY, double scale) {
        GL11.glPushMatrix();
        GL11.glTranslated((double)posX, (double)posY, (double)2.0);
        GL11.glTranslated((double)128.0, (double)128.0, (double)0.0);
        GL11.glScaled((double)scale, (double)scale, (double)scale);
        GL11.glTranslated((double)-128.0, (double)-128.0, (double)0.0);
        WyHelper.drawStringWithBorder(this.font, text, -this.font.func_78256_a(text) / 2, 0, WyHelper.hexToRGB("#FFFFFF").getRGB());
        GL11.glPopMatrix();
    }

    public int getSelectedFactionId() {
        return this.options[0];
    }

    public int getSelectedRaceId() {
        return this.options[1];
    }

    public int getSelectedStyleId() {
        return this.options[2];
    }

    public void increaseSelectedPage() {
        if (this.options[this.page] + 1 < this.maxOpt) {
            int n = this.page;
            this.options[n] = this.options[n] + 1;
        } else {
            this.options[this.page] = 0;
        }
    }

    public void decreaseSelectedPage() {
        if (this.options[this.page] - 1 > -1) {
            int n = this.page;
            this.options[n] = this.options[n] - 1;
        } else {
            this.options[this.page] = this.maxOpt - 1;
        }
    }

    public static void open(boolean hasRandomizedRace) {
        Minecraft.func_71410_x().func_147108_a((Screen)new CharacterCreatorScreen(hasRandomizedRace));
    }
}

