/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.client.gui.ScrollPanel;
import xyz.pixelatedw.mineminenomi.api.abilities.TempoAbility;
import xyz.pixelatedw.mineminenomi.api.helpers.RendererHelper;
import xyz.pixelatedw.mineminenomi.config.ClientConfig;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CEquipAbilityPacket;
import xyz.pixelatedw.mineminenomi.packets.client.ability.CTogglePassiveAbilityPacket;
import xyz.pixelatedw.mineminenomi.screens.SelectHotbarAbilitiesScreen;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.abilities.Ability;
import xyz.pixelatedw.mineminenomi.wypi.abilities.PassiveAbility;
import xyz.pixelatedw.mineminenomi.wypi.data.ability.IAbilityData;
import xyz.pixelatedw.mineminenomi.wypi.network.WyNetwork;

public class AbilitiesListScreenPanel
extends ScrollPanel {
    private SelectHotbarAbilitiesScreen parent;
    private IAbilityData props;
    private List<Entry> allAbilities = new ArrayList<Entry>();
    private List<Entry> activeAbilities = new ArrayList<Entry>();
    private List<Entry> passiveAbilities = new ArrayList<Entry>();
    private static final int ENTRY_HEIGHT = 20;

    public AbilitiesListScreenPanel(SelectHotbarAbilitiesScreen parent, IAbilityData abilityProps, Ability[] abilities) {
        super(parent.getMinecraft(), 215, 130, parent.height / 2 - 98, parent.width / 2 - 109);
        this.parent = parent;
        this.props = abilityProps;
        for (int i = 0; i <= abilities.length - 1; ++i) {
            boolean hideInGUI = abilities[i].isHideInGUI();
            boolean isPassive = abilities[i] instanceof PassiveAbility;
            boolean isTempo = abilities[i] instanceof TempoAbility;
            if (abilities[i] == null) continue;
            if (!isPassive && !isTempo) {
                this.activeAbilities.add(new Entry(abilities[i]));
                continue;
            }
            if (!isPassive && !isTempo || hideInGUI) continue;
            this.passiveAbilities.add(new Entry(abilities[i]));
        }
        this.allAbilities.addAll(this.activeAbilities);
        if (this.passiveAbilities.size() > 0) {
            this.passiveAbilities.add(0, null);
        }
        this.allAbilities.addAll(this.passiveAbilities);
    }

    public boolean mouseReleased(double p_mouseReleased_1_, double p_mouseReleased_3_, int p_mouseReleased_5_) {
        return true;
    }

    protected int getContentHeight() {
        int size = this.activeAbilities.stream().collect(Collectors.toList()).size();
        if (this.passiveAbilities.size() > 0) {
            size += this.passiveAbilities.size();
        }
        return (int)((double)size * 25.0 + 2.0);
    }

    protected int getScrollAmount() {
        return 15;
    }

    protected void drawPanel(int entryRight, int relativeY, Tessellator tess, int mouseX, int mouseY) {
        float y = relativeY;
        float x = this.parent.width / 2 - 109 + 40;
        for (Entry entry : this.activeAbilities) {
            if (entry == null) continue;
            boolean flag = false;
            if (this.props.hasEquippedAbility(entry.ability)) {
                flag = true;
            }
            String abilityName = WyHelper.isNullOrEmpty(entry.ability.getDisplayName()) ? entry.ability.getName() : entry.ability.getDisplayName();
            Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)("ability.mineminenomi." + WyHelper.getResourceName(abilityName)), (Object[])new Object[0]), x, y + 4.0f, flag ? 0xFF0000 : 0xFFFFFF);
            RendererHelper.drawAbilityIcon(WyHelper.getResourceName(entry.ability.getName()), MathHelper.func_76141_d((float)x) - 30, MathHelper.func_76141_d((float)y), 16, 16);
            y = (float)((double)y + 25.0);
        }
        if (this.passiveAbilities.size() > 0) {
            Minecraft.func_71410_x().field_71466_p.func_175063_a("Passives", x - 20.0f, y + 4.0f, 0x8B8B8B);
            y = (float)((double)y + 25.0);
            for (Entry entry : this.passiveAbilities) {
                if (entry == null) continue;
                Color textColor = WyHelper.hexToRGB("#aaff77");
                Color iconColor = WyHelper.hexToRGB("#FFFFFF");
                if (entry.ability instanceof PassiveAbility && ((PassiveAbility)entry.ability).isPaused()) {
                    textColor = iconColor = WyHelper.hexToRGB("#FF0000");
                }
                if (entry.ability instanceof TempoAbility) {
                    textColor = WyHelper.hexToRGB("#8B8B8B");
                }
                String abilityName = WyHelper.isNullOrEmpty(entry.ability.getDisplayName()) ? entry.ability.getName() : entry.ability.getDisplayName();
                Minecraft.func_71410_x().field_71466_p.func_175063_a(I18n.func_135052_a((String)("ability.mineminenomi." + WyHelper.getResourceName(abilityName)), (Object[])new Object[0]), x, y + 4.0f, textColor.getRGB());
                String texture = entry.ability.hasCustomTexture() ? WyHelper.getResourceName(entry.ability.getCustomTexture()) : WyHelper.getResourceName(entry.ability.getName());
                RendererHelper.drawAbilityIcon(texture, MathHelper.func_76141_d((float)x) - 30, MathHelper.func_76141_d((float)y), 1, 16, 16, (float)iconColor.getRed() / 255.0f, (float)iconColor.getGreen() / 255.0f, (float)iconColor.getBlue() / 255.0f);
                y = (float)((double)y + 25.0);
            }
        }
    }

    private Entry findAbilityEntry(int mouseX, int mouseY) {
        double offset = (float)(mouseY - this.top) + this.scrollDistance;
        if (offset <= 0.0) {
            return null;
        }
        int lineIdx = (int)(offset / 25.0);
        if (lineIdx >= this.allAbilities.size()) {
            return null;
        }
        Entry entry = this.allAbilities.get(lineIdx);
        if (entry != null) {
            return entry;
        }
        return null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        Entry entry = this.findAbilityEntry((int)mouseX, (int)mouseY);
        boolean flag = true;
        if (entry != null) {
            if (entry.ability instanceof PassiveAbility) {
                PassiveAbility passive;
                passive.setPause(!(passive = (PassiveAbility)entry.ability).isPaused());
                WyNetwork.sendToServer(new CTogglePassiveAbilityPacket(entry.ability, passive.isPaused()));
            } else {
                Ability ability = this.props.getEquippedAbility(entry.ability);
                if (ability != null && !ability.isOnStandby()) {
                    flag = false;
                }
                if (this.isMouseOver(mouseX, mouseY) && this.parent.slotSelected >= 0 && flag && entry.ability != null) {
                    this.props.setEquippedAbility(this.parent.slotSelected, entry.ability);
                    WyNetwork.sendToServer(new CEquipAbilityPacket(this.parent.slotSelected, entry.ability));
                    this.parent.markDirty();
                }
            }
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean isMouseOver(double mouseX, double mouseY) {
        return mouseX >= (double)this.left && mouseY >= (double)this.top && mouseX < (double)(this.left + this.width - 5) && mouseY < (double)(this.top + this.height);
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        super.render(mouseX, mouseY, partialTicks);
        if (ClientConfig.INSTANCE.isTooltipMessageEnabled() && this.isMouseOver(mouseX, mouseY)) {
            Entry hoveredEntity = this.findAbilityEntry(mouseX, mouseY);
            if (hoveredEntity == null || hoveredEntity.ability.getDescription() == null) {
                return;
            }
            String tooltip = hoveredEntity.ability.getDescription().func_150254_d();
            double posX = this.parent.width - 220;
            double posY = this.parent.height - 120;
            double width = posX + 220.0;
            double height = posY + 120.0;
            int fgColor = 0xFFFFFF;
            int bgColor1 = WyHelper.hexToRGB("#222222FF").getRGB();
            int bgColor2 = WyHelper.hexToRGB("#686868EE").getRGB();
            this.fillGradient((int)posX, (int)posY, (int)width, (int)height, bgColor1, bgColor2);
            List<String> strings = WyHelper.splitString(this.parent.getMinecraft().field_71466_p, tooltip, (int)posX, 210);
            for (int b = 0; b < strings.size(); ++b) {
                WyHelper.drawStringWithBorder(this.parent.getMinecraft().field_71466_p, strings.get(b), (int)posX + 5, 5 + (int)posY + 10 * b, fgColor);
            }
        }
    }

    class Entry {
        private Ability ability;

        public Entry(Ability ability) {
            this.ability = ability;
        }
    }
}

