/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.screens.extra;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.lwjgl.opengl.GL11;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;

@OnlyIn(value=Dist.CLIENT)
public class TexturedIconButton
extends Button {
    private ResourceLocation texture;
    private int textureWidth;
    private int textureHeight;
    private int texturePosX;
    private int texturePosY;
    private int textPosX;
    private int textPosY;
    private double textScale = 1.0;
    private ResourceLocation iconTexture;
    private double iconScale = 1.0;
    private int iconPosX;
    private int iconPosY;
    private boolean isPressed;

    public TexturedIconButton(ResourceLocation loc, int posX, int posY, int width, int height, String text, Button.IPressable onPress) {
        super(posX, posY, width, height, text, onPress);
        this.texture = loc;
        this.texturePosX = posX;
        this.texturePosY = posY;
        this.textureWidth = width;
        this.textureHeight = height;
    }

    public TexturedIconButton setTextureInfo(int texturePosX, int texturePosY, int textureWidth, int textureHeight) {
        this.texturePosX = texturePosX;
        this.texturePosY = texturePosY;
        this.textureWidth = textureWidth;
        this.textureHeight = textureHeight;
        return this;
    }

    public TexturedIconButton setTextInfo(int textPosX, int textPosY, double scale) {
        this.textPosX = textPosX;
        this.textPosY = textPosY - 7;
        this.textScale = scale;
        return this;
    }

    public TexturedIconButton setIconInfo(ResourceLocation loc, int iconPosX, int iconPosY, double scale) {
        this.iconTexture = loc;
        this.iconPosX = iconPosX;
        this.iconPosY = iconPosY;
        this.iconScale = scale;
        return this;
    }

    public void render(int mouseX, int mouseY, float partialTicks) {
        if (!this.visible) {
            return;
        }
        this.isHovered = this.active && mouseX >= this.x && mouseY >= this.y && mouseX < this.x + this.width && mouseY < this.y + this.height;
        RenderSystem.pushMatrix();
        if (this.isHovered || this.isPressed) {
            RenderSystem.translated((double)0.0, (double)0.5, (double)0.0);
            RenderSystem.color3f((float)0.7f, (float)0.7f, (float)0.7f);
        }
        if (!this.active) {
            RenderSystem.color3f((float)0.5f, (float)0.5f, (float)0.5f);
        }
        WyHelper.drawIcon(this.texture, this.texturePosX, this.texturePosY, this.textureWidth, this.textureHeight);
        if (this.iconTexture != null) {
            RenderSystem.pushMatrix();
            RenderSystem.enableBlend();
            RenderSystem.translated((double)this.iconPosX, (double)this.iconPosY, (double)2.0);
            GL11.glTranslated((double)16.0, (double)16.0, (double)0.0);
            GL11.glScaled((double)this.iconScale, (double)this.iconScale, (double)this.iconScale);
            GL11.glTranslated((double)-16.0, (double)-16.0, (double)1.0);
            WyHelper.drawIcon(this.iconTexture, 0, 0, 16, 16);
            RenderSystem.popMatrix();
        }
        RenderSystem.pushMatrix();
        FontRenderer font = Minecraft.func_71410_x().field_71466_p;
        List<String> strings = Arrays.asList(this.getMessage());
        int splits = this.getMessage().split(" ").length;
        if (splits > 1) {
            strings = WyHelper.splitString(font, this.getMessage(), this.textPosX - font.func_78256_a(this.getMessage()) / 2 + 26, this.width / splits + 10);
        }
        RenderSystem.translated((double)this.textPosX, (double)(this.textPosY - (strings.size() > 1 ? strings.size() * 3 : 0)), (double)2.0);
        RenderSystem.translated((double)128.0, (double)128.0, (double)0.0);
        RenderSystem.scaled((double)this.textScale, (double)this.textScale, (double)this.textScale);
        RenderSystem.translated((double)-128.0, (double)-128.0, (double)1.0);
        for (int b = 0; b < strings.size(); ++b) {
            WyHelper.drawStringWithBorder(font, strings.get(b), 0, 7 + b * 9, WyHelper.hexToRGB("#FFFFFF").getRGB());
        }
        RenderSystem.popMatrix();
        RenderSystem.color3f((float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void setIsPressed(boolean flag) {
        this.isPressed = flag;
    }
}

