/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.features.structures.skyisland.town;

import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Mirror;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IWorld;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.TemplateStructurePiece;
import net.minecraft.world.gen.feature.template.BlockIgnoreStructureProcessor;
import net.minecraft.world.gen.feature.template.PlacementSettings;
import net.minecraft.world.gen.feature.template.StructureProcessor;
import net.minecraft.world.gen.feature.template.Template;
import net.minecraft.world.gen.feature.template.TemplateManager;
import xyz.pixelatedw.mineminenomi.api.helpers.StructuresHelper;
import xyz.pixelatedw.mineminenomi.blocks.tileentities.CustomSpawnerTileEntity;
import xyz.pixelatedw.mineminenomi.init.ModBlocks;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModFeatures;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class SkyIslandTownPieces {
    private static final ResourceLocation PIECE = new ResourceLocation("mineminenomi", "sky_islands/town");
    private static final Map<ResourceLocation, BlockPos> POSITION_OFFSET = ImmutableMap.builder().put((Object)PIECE, (Object)new BlockPos(0, 0, 0)).build();
    private static final Map<ResourceLocation, BlockPos> CENTER_OFFSET = ImmutableMap.builder().put((Object)PIECE, (Object)new BlockPos(0, 0, 0)).build();

    public static void addComponents(TemplateManager templateManager, BlockPos pos, List<StructurePiece> components) {
        components.add((StructurePiece)new Piece(templateManager, PIECE, pos, (StructureProcessor)BlockIgnoreStructureProcessor.field_215204_a));
    }

    public static class Piece
    extends TemplateStructurePiece {
        private ResourceLocation resourceLocation;
        private Rotation rotation;
        private StructureProcessor processor;
        private BlockPos centerPosition;

        public Piece(TemplateManager template, CompoundNBT nbt) {
            super(ModFeatures.Pieces.SKY_ISLAND_TOWN_PIECE, nbt);
            this.resourceLocation = new ResourceLocation(nbt.func_74779_i("Template"));
            this.rotation = Rotation.valueOf((String)nbt.func_74779_i("Rot"));
            short centerX = nbt.func_74765_d("CenterX");
            short centerY = nbt.func_74765_d("CenterY");
            short centerZ = nbt.func_74765_d("CenterZ");
            this.centerPosition = new BlockPos((int)centerX, (int)centerY, (int)centerZ);
            this.processor = BlockIgnoreStructureProcessor.field_215204_a;
            this.build(template);
        }

        public Piece(TemplateManager template, ResourceLocation res, BlockPos pos, StructureProcessor proc) {
            super(ModFeatures.Pieces.SKY_ISLAND_TOWN_PIECE, 0);
            this.rotation = Rotation.NONE;
            this.resourceLocation = res;
            BlockPos blockpos = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.centerPosition = pos;
            this.field_186178_c = pos.func_177982_a(blockpos.func_177958_n(), blockpos.func_177956_o(), blockpos.func_177952_p());
            this.processor = proc;
            this.build(template);
        }

        protected void func_143011_b(CompoundNBT nbt) {
            super.func_143011_b(nbt);
            nbt.func_74778_a("Template", this.resourceLocation.toString());
            nbt.func_74778_a("Rot", this.rotation.name());
            nbt.func_74768_a("CenterX", this.centerPosition.func_177958_n());
            nbt.func_74768_a("CenterY", this.centerPosition.func_177956_o());
            nbt.func_74768_a("CenterZ", this.centerPosition.func_177952_p());
        }

        private void build(TemplateManager templateManager) {
            Template template = templateManager.func_200220_a(this.resourceLocation);
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a(this.processor);
            this.func_186173_a(template, this.field_186178_c, placementsettings);
        }

        protected void func_186175_a(String function, BlockPos pos, IWorld world, Random rand, MutableBoundingBox sbb) {
            if (function.equals("islander_spawn")) {
                int spawnType = rand.nextInt(3);
                int spawnNum = 1 + rand.nextInt(2);
                if (spawnType == 0) {
                    StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.SKYPIEAN, StructuresHelper.StructureSpawnType.CIVILIAN, 5);
                } else if (spawnType == 1) {
                    StructuresHelper.spawnMobs(world, pos, StructuresHelper.StructureFaction.SKYPIEAN, StructuresHelper.StructureSpawnType.TRADER, spawnNum);
                } else if (spawnType == 2) {
                    world.func_180501_a(pos, ModBlocks.CUSTOM_SPAWNER.func_176223_P(), 3);
                    if (world.func_175625_s(pos) instanceof CustomSpawnerTileEntity) {
                        CustomSpawnerTileEntity spawner = null;
                        spawner = (CustomSpawnerTileEntity)world.func_175625_s(pos);
                        spawner.setSpawnerLimit(1);
                        spawner.setSpawnerMob(ModEntities.ART_OF_WEATHER_TRAINER);
                    }
                }
            }
        }

        public boolean func_225577_a_(IWorld world, ChunkGenerator<?> generator, Random random, MutableBoundingBox bb, ChunkPos chunkPos) {
            if (this.centerPosition == null) {
                WyDebug.debug("Somehow the Center Position of this structure is null. Contact the owner!");
                return false;
            }
            PlacementSettings placementsettings = new PlacementSettings().func_186220_a(this.rotation).func_186214_a(Mirror.NONE).func_207665_a((BlockPos)CENTER_OFFSET.get(this.resourceLocation)).func_215222_a(this.processor);
            BlockPos offset = (BlockPos)POSITION_OFFSET.get(this.resourceLocation);
            this.field_186178_c.func_177971_a((Vec3i)Template.func_186266_a((PlacementSettings)placementsettings, (BlockPos)new BlockPos(offset.func_177958_n(), offset.func_177956_o(), offset.func_177952_p())));
            return super.func_225577_a_(world, generator, random, bb, chunkPos);
        }
    }
}

