/*
 * Decompiled with CFR 0.152.
 */
package xyz.pixelatedw.mineminenomi.world.spawners;

import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.server.ServerWorld;
import xyz.pixelatedw.mineminenomi.api.entities.TrainerEntity;
import xyz.pixelatedw.mineminenomi.api.quests.Quest;
import xyz.pixelatedw.mineminenomi.config.CommonConfig;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.EntityStatsCapability;
import xyz.pixelatedw.mineminenomi.data.entity.entitystats.IEntityStats;
import xyz.pixelatedw.mineminenomi.data.entity.quests.QuestDataCapability;
import xyz.pixelatedw.mineminenomi.init.ModEntities;
import xyz.pixelatedw.mineminenomi.init.ModQuests;
import xyz.pixelatedw.mineminenomi.wypi.WyHelper;
import xyz.pixelatedw.mineminenomi.wypi.debug.WyDebug;

public class TrainerSpawner {
    private Random random = new Random();
    private int cooldown;

    public void tick(ServerWorld world) {
        world.func_217381_Z().func_76320_a("traderSpawnerTick");
        if (--this.cooldown <= 0) {
            this.cooldown = CommonConfig.INSTANCE.getTimeBetweenTrainerSpawns();
            if (this.random.nextInt(100) <= CommonConfig.INSTANCE.getChanceForTrainerSpawn()) {
                this.spawn(world);
            }
        }
        world.func_217381_Z().func_76319_b();
    }

    private void spawn(ServerWorld world) {
        world.func_217381_Z().func_76320_a("trainerSpawnerSpawn");
        ServerPlayerEntity player = world.func_217472_l_();
        if (player == null) {
            return;
        }
        IEntityStats props = EntityStatsCapability.get((LivingEntity)player);
        EntityType entityType = null;
        Quest[] quests = null;
        if (props.isSwordsman()) {
            entityType = ModEntities.SWORDSMAN_TRAINER;
            quests = ModQuests.SWORDSMAN_TRIALS;
        } else if (props.isSniper()) {
            entityType = ModEntities.SNIPER_TRAINER;
            quests = ModQuests.SNIPER_TRIALS;
        } else if (props.isWeatherWizard()) {
            entityType = ModEntities.ART_OF_WEATHER_TRAINER;
            quests = ModQuests.ART_OF_WEATHER_TRIALS;
        } else if (props.isDoctor()) {
            entityType = ModEntities.DOCTOR_TRAINER;
            quests = ModQuests.DOCTOR_TRIALS;
        } else if (props.isBrawler()) {
            entityType = ModEntities.BRAWLER_TRAINER;
            quests = ModQuests.BRAWLER_TRIALS;
        } else if (props.isBlackLeg()) {
            entityType = ModEntities.BLACK_LEG_TRAINER;
            quests = ModQuests.BLACK_LEG_TRIALS;
        }
        if (entityType == null) {
            return;
        }
        BlockPos targetPos = player.func_180425_c();
        BlockPos spawnPos = WyHelper.findOnGroundSpawnLocation((World)world, entityType, targetPos, 20);
        if (spawnPos == null) {
            return;
        }
        List trainers = WyHelper.getEntitiesNear(spawnPos, (World)world, 100.0).stream().filter(entity -> entity instanceof TrainerEntity).collect(Collectors.toList());
        boolean hasAvailableQuests = true;
        if (quests != null) {
            for (Quest trial : quests) {
                if (!QuestDataCapability.get((PlayerEntity)player).hasFinishedQuest(trial)) break;
                hasAvailableQuests = false;
            }
        }
        if (spawnPos != null && hasAvailableQuests) {
            boolean canSpawnInBiome;
            boolean bl = canSpawnInBiome = world.func_226691_t_(targetPos).func_201856_r() != Biome.Category.OCEAN;
            if (trainers.size() < 2 && canSpawnInBiome) {
                entityType.func_220342_a((World)world, (CompoundNBT)null, (ITextComponent)null, (PlayerEntity)null, spawnPos, SpawnReason.EVENT, false, false);
                WyDebug.debug("Trainer spawned at: " + spawnPos);
            }
        }
        world.func_217381_Z().func_76319_b();
    }
}

